#include <stdlib.h>
#include <gtk/gtk.h>

#include "status.h"

static GtkWidget *hbox;
static GtkWidget *sbar;
static guint context_id;
static GtkWidget *pbar;

GtkWidget *status_bar_new(void)
{
  hbox = gtk_hbox_new(FALSE, 5);
  sbar = gtk_statusbar_new();
  context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(sbar),
                                            "GtkSQL status");
  gtk_widget_show(sbar);
  pbar = gtk_progress_bar_new();
  gtk_widget_set_usize(pbar, 150, 20);
  gtk_widget_show(pbar);
 
  gtk_box_pack_start(GTK_BOX(hbox), sbar, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), pbar, FALSE, FALSE, 0);

  return hbox;
}

void status_push(gchar *msg)
{
  gtk_statusbar_push(GTK_STATUSBAR(sbar), context_id, msg);
  while (gtk_events_pending())
    gtk_main_iteration();
}

void status_pop(void)
{
  gtk_statusbar_pop(GTK_STATUSBAR(sbar), context_id);
  while (gtk_events_pending())
    gtk_main_iteration();
}

void status_reset(void)
{
  gtk_progress_bar_update(GTK_PROGRESS_BAR(pbar),  0.0);
  while (gtk_events_pending())
    gtk_main_iteration();
}

void status_update(gfloat percentage)
{
  gtk_progress_bar_update(GTK_PROGRESS_BAR(pbar), percentage);
  while (gtk_events_pending())
    gtk_main_iteration();
}
