# Gufw 9.10.2 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Raul Soriano & Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


import gtk
import os
import os.path
from model.Variable import Variable


variable = Variable()

    
# Check if gufw is root application
class Check:

    def is_root(self):
    
        if os.geteuid() == 0:
            return True
        else:
            dlg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format=variable.get_text("018"))
            dlg.run()
            dlg.destroy()
            return False
        
        
# This class manages application instances
class Instance:

    #specify the file where the pid is stores (pid file)
    def __init__(self):
        self.pid_file = variable.get_path("pid_file")
        self.check()
        self.startApplication()

    #check wether the app is running
    def check(self):
        #check wether the pid file exists
        if not os.path.isfile(self.pid_file):
            return

        #read the pid from file
        pid = 0
        try:
            file = open(self.pid_file, 'rt')
            data = file.read()
            file.close()
            pid = int(data)
        except:
            pass

        #check wether the proccess specified exists
        if 0 == pid:
            return
        try:
            os.kill(pid, 0)  #this raises an exception if the pid is invalid
        except:
            return

        #exit the program
        exit(0) # exit reaises an exception, so there is no need for a try/except block

    #called when there is no running instances, storing the new pid (creating a instance)
    def startApplication(self):
        file = open(self.pid_file, 'wt')
        file.write( str(os.getpid()))
        file.close()

    #called when the running insnstance exits, removing the existing pid file (destroying the existing instance)
    def exitApplication(self):
    # Close WindowsxitApplication(self):
        try:
            os.remove(self.pid_file)
        except:
            pass
