 /*
 *  IconsViewer.h: Interface and declarations for the IconsViewer Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ICONSVIEWER_H
#define ICONSVIEWER_H

#import <AppKit/NSView.h>
#include "ViewersProtocol.h"

@class NSString;
@class NSArray;
@class NSDictionary;
@class NSNotification;
@class NSFileManager;
@class PathIcon;
@class IconsPath;
@class IconsPanel;
@class NSScrollView;
@class GWScrollView;

@interface IconsViewer : NSView <ViewersProtocol>
{
  IconsPanel *panel;
  IconsPath *iconsPath;
  GWScrollView *pathsScroll;
	NSScrollView *panelScroll;
  BOOL viewsapps;
  BOOL autoSynchronize;
  int resizeIncrement;
  int columns;
  float columnsWidth;
  NSString *rootPath;
	NSArray *selectedPaths;
  NSArray *watchedPaths;
	id delegate;
  NSFileManager *fm;
}

- (void)validateRootPathAfterOperation:(NSDictionary *)opdict;

- (void)fileSystemWillChange:(NSNotification *)notification;

- (void)fileSystemDidChange:(NSNotification *)notification;

- (void)sortTypeDidChange:(NSNotification *)notification;

- (void)watcherNotification:(NSNotification *)notification;

- (void)setWatchersFromTimer:(id)sender;

- (void)setWatchers;

- (void)setWatcherForPath:(NSString *)path;

- (void)unsetWatchers;

- (void)unsetWatcherForPath:(NSString *)path;

- (void)openCurrentSelection:(NSArray *)paths newViewer:(BOOL)newv;

- (void)clickOnIcon:(PathIcon *)icon;

- (void)doubleClickOnIcon:(PathIcon *)icon newViewer:(BOOL)isnew;

- (void)synchronize;

- (void)closeNicely;

- (void)close:(id)sender;

@end

//
// Methods Implemented by the Delegate 
//

@interface NSObject (ViewerDelegateMethods)

- (void)setTheSelectedPaths:(id)paths;

- (void)addWatcherForPath:(id)path;

- (void)removeWatcherForPath:(id)path;

- (void)addPathToHistory:(NSArray *)paths;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (void)openTheSelectedPaths:(id)paths newViewer:(BOOL)newv;

- (void)newViewerAtPath:(id)path canViewApps:(BOOL)viewapps;

- (BOOL)openFile:(id)fullPath;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSString *)getTrashPath;

- (void)updateTheInfoString;

- (int)getBrowserColumnsWidth;

- (int)getIconViewCellsWidth;

- (int)getWindowFrameWidth;

- (int)getWindowFrameHeight;

@end

//
// IconsPanel Delegate Methods
//

@interface IconsViewer (IconsPanelDelegateMethods)

- (void)setTheSelectedPaths:(id)paths;

- (void)openTheCurrentSelection:(id)paths newViewer:(BOOL)newv;

- (void)performFileOperationWithDictionary:(id)opdict;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (NSString *)getTrashPath;

- (int)getIconViewCellsWidth;

@end

//
// IconsPath Delegate Methods
//

@interface IconsViewer (IconsPathDelegateMethods)

- (void)clickedIcon:(id)anicon;

- (void)doubleClickedIcon:(id)anicon newViewer:(BOOL)isnew;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSString *)getTrashPath;

@end

#endif // ICONSVIEWER_H

