/*
 *  PermsBox.h: Interface and declarations for the PermsBox Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PERMISSIONSBOX_H
#define PERMISSIONSBOX_H

#import <AppKit/NSBox.h>
#import <AppKit/NSView.h>

@class NSButton;
@class NSImage;

@interface PermsBox : NSBox
{
	id panel;
	NSButton *ureadbutt, *uwritebutt;
	NSButton *greadbutt, *gwritebutt;
	NSButton *oreadbutt, *owritebutt; 
	NSImage *onImage, *offImage, *multipleImage;
	BOOL multiplePaths;
}

- (id)initInPanel:(id)aPanel;

- (void)setPermissions:(int)perms isActive:(BOOL)active;

- (int)getPermissions:(int)oldperms;

- (void)buttonClicked:(id)sender;

@end

@interface PermsBox2 : NSView
{
	id panel;
	NSButton *ureadbutt, *uwritebutt, *uexebutt;
	NSButton *greadbutt, *gwritebutt, *gexebutt;
	NSButton *oreadbutt, *owritebutt, *oexebutt; 
	NSImage *onImage, *offImage, *multipleImage;
	BOOL multiplePaths;
}

- (id)initInPanel:(id)aPanel;

- (void)setPermissions:(int)perms isActive:(BOOL)active;

- (int)getPermissions:(int)oldperms;

- (void)buttonClicked:(id)sender;

@end

#endif // PERMISSIONSBOX_H
