
;; Don't need this, no one else will be loading this file.
;(define-module (g-wrapped gw-test-child-spec)
;  :use-module (g-wrap))

(let ((m (gw:new-module "gw-test-child")))

  (gw:module-set-guile-module! m '(test gw-test-child))

  (gw:module-depends-on m "gw-runtime")
  (gw:module-depends-on m "gw-test-parent")

  (gw:module-set-declarations-ccodegen!
   m
   (lambda (client-only?)
     (list
      "#include \"gw-test-child-code.h\"\n")))

  (let ((nnt (gw:wrap-non-native-type
              m
              '<gw:TestChildObj*>
              "gwTestChildObj*" "const gwTestChildObj*")))
    #t)

  (gw:wrap-function
   m
   'gw-test-child-make-obj
   '<gw:TestChildObj*>
   "gw_test_child_make_obj"
   '(((<gw:m-chars-caller-owned> gw:const) data))
   "Make a gwTestChildObj*.")

  (gw:wrap-function
   m
   'gw-test-child-same-obj
   '<gw:TestChildObj*>
   "gw_test_child_same_obj"
   '((<gw:TestChildObj*> data))
   "Make a gwTestChildObj*.")

  (gw:wrap-function
   m
   'gw-test-child-display-obj
   '<gw:void>
   "gw_test_child_display_obj"
   '(((<gw:TestChildObj*> gw:const) f)))

  
  #t)
