/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "preferences.h"
#include "support.h"

preferencestype preferences;

void
loadpreferences (void)
{
  gchar *preferencesfile, label[210], value[210];
  FILE *fp;

  /* defaults */
  preferences.types = g_strdup(_("brooch, buckle, button, coin, jewellery, pottery, religious, thimble, token, unknown, weight"));
  preferences.materials = g_strdup(_("bone, bronze, copper, glass, gold, iron, lead, silver"));
  preferences.periods = g_strdup(_("celtic, roman, anglo saxon, medieval, late medieval, unknown"));
  preferences.colvisible = g_strdup("1,1,1,1,1,1,1,1,1,1,1,1,1,1,1");

  /* open preferences file */
	preferencesfile = g_strdup_printf ("%s%s.%s%spreferences", 
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE, G_DIR_SEPARATOR_S);
  fp = fopen (preferencesfile, "r");
  if (fp)
  {
    while (!feof (fp))
      {
        if (fscanf (fp, "%s %s", label, value) == EOF) break;
        if (!g_ascii_strcasecmp(label, "types"))
        {
          g_strdelimit (value, "~", ' ');
          preferences.types = g_strdup(value);
        }
        else if (!g_ascii_strcasecmp(label, "materials"))
        {
          g_strdelimit (value, "~", ' ');
          preferences.materials = g_strdup(value);
        }
        else if (!g_ascii_strcasecmp(label, "periods"))
        {
          g_strdelimit (value, "~", ' ');
          preferences.periods = g_strdup(value);
        }
        else if (!g_ascii_strcasecmp(label, "colvisible")) 
          preferences.colvisible = g_strdup(value);
      }
    fclose (fp);
  }
  g_free(preferencesfile);
}

/*
 * save preferences in ~/.xdx/preferences
 */

void
savepreferences (void)
{
  gchar *preferencesfile, *str;
  FILE *fp;

  /* open preferences file */
	preferencesfile = g_strdup_printf ("%s%s.%s%spreferences", 
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE, G_DIR_SEPARATOR_S);
  fp = fopen (preferencesfile, "w");
  if (fp)
  {
    str = g_strdup_printf("%s", preferences.types);
    g_strdelimit (str, " ", '~');
    fprintf(fp, "types %s\n", str);
    str = g_strdup_printf("%s", preferences.materials);
    g_strdelimit (str, " ", '~');
    fprintf(fp, "materials %s\n", str);
    str = g_strdup_printf("%s", preferences.periods);
    g_strdelimit (str, " ", '~');
    fprintf(fp, "periods %s\n", str);
    str = g_strdup_printf("%s", preferences.colvisible);
    fprintf(fp, "colvisible %s\n", str);
    g_free(str);
    fclose (fp);
  }
  g_free(preferencesfile);
  g_free(preferences.types);
  g_free(preferences.materials);
  g_free(preferences.periods);
  g_free(preferences.colvisible);
  
}
