/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>

/*
 * In this example we will open an HDF-EOS file and attach to UTM and Polar
 * Stereographic grid structures within the file to read a dimension scales
 * and its attributes
 */


int main()
{
  herr_t          status = FAIL;
  hid_t           gdfid = FAIL;
  hid_t           GDid1 = FAIL;
  int             i,j;
  int             bufsize;
  double         *databuff;
  long            nattr;
  long            strbufsize;
  char           *attrlist;
  size_t          fldnmlen[HE5_HDFE_NAMBUFSIZE];
  char           *fldnm[HE5_HDFE_NAMBUFSIZE];
  char           *attrname = (char *)NULL;
  hid_t          *ntype;
  hsize_t        count = 0;
  void           *attr;
  int            *attr_int;
  float          *attr_flt;
  char           *attr_char;
  hsize_t         dimsize;
  hid_t           numtype;

  /*
   * Open the HDF grid file, "Grid.h5".
   */

  gdfid = HE5_GDopen("Grid.h5", H5F_ACC_RDWR);
 
  /*
   * If the grid file cannot be found, HE5_GDopen will return -1 for the file
   * handle (gdfid).  We there check that this is not the case before
   * proceeding with the other routines.
   * 
   * The HE5_GDattach routine returns the handle to the existing grid "Grid1",
   * GDid.  If the grid is not found, HE5_GDattach returns -1 for the handle.
   */ 

  if (gdfid != FAIL)
    {	  
      GDid1 = HE5_GDattach(gdfid, "UTMGrid");

      /* the field Pollution has Time,YDim,XDim dimensions. 
	 xdim = 120;
	 ydim = 200;
	 Time dim is set to 10
      */

      if (GDid1 == FAIL)
	{
	  printf("\t\tError: Cannot attach to grid \"UTMGrid\"\n");
	  HE5_GDclose(gdfid);
	  return -1;
	}

      bufsize = HE5_GDgetdimscale(GDid1, "Pollution", "XDim", &dimsize, &numtype, NULL);
      if (bufsize == -1)
	{
	  printf("\t\tError: Cannot get Dimension Scale size for XDim dimemnsion in field \"Pollution\"\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      else
	{
	  printf ("bufsize = %d \n",(int)bufsize);
	  printf ("dimsize = %d \n",(int)dimsize);
	  printf ("numtype = %d\n", (int)numtype);
	}
      databuff = (double *) malloc(bufsize);
      bufsize = HE5_GDgetdimscale(GDid1, "Pollution", "XDim", &dimsize, &numtype, (void *)databuff);

      if (bufsize == -1)
	{
	  printf("\t\tError: Cannot get Dimension Scale for XDim dimemnsion in field \"Pollution\"\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  free(databuff);
	  return -1;
	}
      else
	{
	  printf ("First 10 values are:\n");
	  for( i = 0; i < 10; i++)
	    {
	      printf ("DimscaleValue[%d] = %lf\n",i,databuff[i]);
	    }
	}

      nattr = HE5_GDinqdscaleattrs(GDid1, "XDim", NULL, &strbufsize);
      if ( nattr < 0 )
	{
	  printf("\t\tError: Cannot get Dimension Scale attribute list for \"XDim\"\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  free(attrlist);
	  return -1;
	}

      attrlist = (char *) calloc(strbufsize + 2, sizeof(char));
      nattr = HE5_GDinqdscaleattrs(GDid1, "XDim", attrlist, &strbufsize);
      if ( nattr < 0 )
	{
	  printf("\t\tError: Cannot get Dimension Scale attribute list for \"XDim\"\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  free(attrlist);
	  return -1;
	}
	  printf(" \n");
	  printf("Dimension scale for \"XDim\" Attribute: \n");
      nattr = HE5_EHparsestr(attrlist, ',', fldnm, fldnmlen);
      if(nattr != FAIL)
	{
	  for( i = 0; i < nattr; i++)
	    {
	      attrname = (char *)calloc(fldnmlen[i] + 1, sizeof(char));
	      memmove(attrname,fldnm[i],fldnmlen[i]);
	      ntype = (hid_t *)calloc(1, sizeof(hid_t));
	      if(strcmp(attrname, "REFERENCE_LIST") ==0 ) continue;
	      status = HE5_GDdscaleattrinfo(GDid1,"XDim", attrname, ntype, &count);
	      if( (int)*ntype == 0) {
		attr_int = (int *)malloc(count*sizeof(int));
		attr = (void *) attr_int;
	      }

	      if( (int)*ntype == 10) {
		attr_flt = (float *)malloc(count*sizeof(float));
		attr = (void *) attr_flt;
	      }

	      if( (int)*ntype == 57) {
		attr_char = (char *)malloc((count+1)*sizeof(char));
		attr = (void *) attr_char;
	      }
	      status = HE5_GDreaddscaleattr(GDid1,"XDim", attrname, attr);
	      printf("\n");
	      printf("Status returned by HE5_GDreaddscaleattr() :  %d \n", status );
	      printf("\tAttribute Name:               %s  \n",attrname);
	      printf("\tNumber of attribute elements: %lu \n", (unsigned long)count);
	      printf("\tData type of attribute:       %d \n", (int)*ntype);

	      if( (int)*ntype == 0) {
		attr_int = (int *)attr;
		for (j = 0; j < count; j++)
		  {
		    printf("\tAttrvalue[%d]:                 %d \n", j,attr_int[j]);
		  }
	      }

	      if( (int)*ntype == 10) {
		attr_flt = (float *)attr;
		for (j = 0; j < count; j++)
		  {
		    printf("\tAttrvalue[%d]:                 %f \n", j,attr_flt[j]);
		  }
	      }

	      if( (int)*ntype == 57) {
		attr_char = (char *)attr;
		attr_char[count]='\0';
		printf("\tAttrvalue:                    %s \n", attr_char);
		free(attr_char);
	      }
	    }
	}
      
      HE5_GDdetach(GDid1);
      
      HE5_GDclose(gdfid);
      
      return 0;
    }
}
