/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxeffect.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PXEFFECT_H
#define _PXEFFECT_H

// Forward declarations
typedef struct HXEXPORT_CLASS _HXxRect HXxRect;
class PXRect;
class CHXString;
class PXColor;


class PXEffect : public CHXBaseCountingObject,
                 public CUnknownIMP
{
    DECLARE_UNKNOWN(PXEffect)
public:
    enum
    {
        kEffectTypeFill       = 0,
        kEffectTypeFadeIn     = 1,
        kEffectTypeFadeOut    = 2,
        kEffectTypeCrossFade  = 3,
        kEffectTypeWipe       = 4,
        kEffectTypeViewChange = 5,
        kEffectTypeExternal   = 6,
        kEffectTypeAnimate    = 7,

        kWipeDirectionUp      = 0,
        kWipeDirectionDown    = 1,
        kWipeDirectionLeft    = 2,
        kWipeDirectionRight   = 3,

        kWipeTypeNormal       = 0,
        kWipeTypePush         = 1
    };

    PXEffect()
    {
        m_ucEffectType        = kEffectTypeFill;
        m_ulStart             = 0;
        m_ulDuration          = 0;
        m_ulTarget            = 0;
        m_bHasTarget          = FALSE;
        m_ulMaxFps            = 0;
        m_bAspectFlag         = TRUE;
        m_ucWipeDirection     = kWipeDirectionUp;
        m_ucWipeType          = kWipeTypeNormal;
        m_bFirstUse           = TRUE;
        m_bLastUse            = TRUE;
        m_bDisplayImmediately = FALSE;
        m_ulHandle            = 0;
        m_ulSendTime          = 0;
        m_lStartSendTime      = 0;
        m_bCenterFlag         = FALSE;
	m_bPostBackChannel    = FALSE;
    };

    ~PXEffect() {};

    BYTE             GetEffectType()         const { return m_ucEffectType;           }
    UINT32           GetStart()              const { return m_ulStart;                }
    UINT32           GetDuration()           const { return m_ulDuration;             }
    UINT32           GetEnd()                const { return m_ulStart + m_ulDuration; }
    BOOL             HasTarget()             const { return m_bHasTarget;             }
    UINT32           GetTarget()             const { return m_ulTarget;               }
    BOOL             GetAspectFlag()         const { return m_bAspectFlag;            }
    BYTE             GetWipeDirection()      const { return m_ucWipeDirection;        }
    BYTE             GetWipeType()           const { return m_ucWipeType;             }
    UINT32           GetMaxFps()             const { return m_ulMaxFps;               }
    BOOL             GetFirstUse()           const { return m_bFirstUse;              }
    BOOL             GetLastUse()            const { return m_bLastUse;               }
    BOOL             GetDisplayImmediately() const { return m_bDisplayImmediately;    }
    const PXRect&    GetSrcRect()            const { return m_cSrcRect;               }
    const PXRect&    GetDstRect()            const { return m_cDstRect;               }
    HXxRect          GetSrcHXxRect()         const;
    HXxRect          GetDstHXxRect()         const;
    UINT32           GetDstX()               const { return m_cDstRect.GetX();        }
    UINT32           GetDstY()               const { return m_cDstRect.GetY();        }
    UINT32           GetDstWidth()           const { return m_cDstRect.GetWidth();    }
    UINT32           GetDstHeight()          const { return m_cDstRect.GetHeight();   }
    UINT32           GetStartDstX()          const { return m_cStartDstRect.GetX();      }
    UINT32           GetStartDstY()          const { return m_cStartDstRect.GetY();      }
    UINT32           GetStartDstWidth()      const { return m_cStartDstRect.GetWidth();  }
    UINT32           GetStartDstHeight()     const { return m_cStartDstRect.GetHeight(); }
    const PXRect&    GetStartSrcRect()       const { return m_cStartSrcRect;          }
    const PXRect&    GetStartDstRect()       const { return m_cStartDstRect;          }
    const CHXString& GetURL()                const { return m_cURL;                   }
    const PXColor&   GetColor()              const { return m_cColor;                 }
    const CHXString& GetExFxPackage()        const { return m_cPackage;               }
    const CHXString& GetExFxName()           const { return m_cName;                  }
    const CHXString& GetExFxData()           const { return m_cData;                  }
    const CHXString& GetExFxFile()           const { return m_cFile;                  }
    BOOL             GetCenterFlag()         const { return m_bCenterFlag;            }
    UINT32           GetHandle()             const { return m_ulHandle;               }
    UINT32           GetSendTime()           const { return m_ulSendTime;             }
    INT32            GetStartSendTime()      const { return m_lStartSendTime;         }
    BOOL             GetPostBackChannel()    const { return m_bPostBackChannel;       }

    void SetEffectType(BYTE ucEffectType);
    void SetStart(UINT32 ulStart)                                   { m_ulStart = ulStart;                 }
    void SetDuration(UINT32 ulDuration)                             { m_ulDuration = ulDuration;           }
    void SetTarget(UINT32 ulTarget)                                 { m_ulTarget = ulTarget;               }
    void SetAspectFlag(BOOL bAspectFlag)                            { m_bAspectFlag = bAspectFlag;         }
    void SetWipeDirection(BYTE ucWipeDirection)                     { m_ucWipeDirection = ucWipeDirection; }
    void SetWipeType(BYTE ucWipeType)                               { m_ucWipeType = ucWipeType;           }
    void SetMaxFps(UINT32 ulMaxFps)                                 { m_ulMaxFps = ulMaxFps;               }
    void SetDstRect(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH) { m_cDstRect.Set(ulX, ulY, ulW, ulH);  }
    void SetDstRect(const PXRect &rRect)                            { m_cDstRect = rRect;                  }
    void SetDstX(UINT32 ulX)                                        { m_cDstRect.SetX(ulX);                }
    void SetDstY(UINT32 ulY)                                        { m_cDstRect.SetY(ulY);                }
    void SetDstWidth(UINT32 ulW)                                    { m_cDstRect.SetWidth(ulW);            }
    void SetDstHeight(UINT32 ulH)                                   { m_cDstRect.SetHeight(ulH);           }
    void SetStartDstX(UINT32 ulX)                                   { m_cStartDstRect.SetX(ulX);           }
    void SetStartDstY(UINT32 ulY)                                   { m_cStartDstRect.SetY(ulY);           }
    void SetStartDstWidth(UINT32 ulW)                               { m_cStartDstRect.SetWidth(ulW);       }
    void SetStartDstHeight(UINT32 ulH)                              { m_cStartDstRect.SetHeight(ulH);      }
    void SetSrcRect(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH) { m_cSrcRect.Set(ulX, ulY, ulW, ulH);  }
    void SetSrcRect(const PXRect &rRect)                            { m_cSrcRect = rRect;                  }
    void SetSrcX(UINT32 ulX)                                        { m_cSrcRect.SetX(ulX);                }
    void SetSrcY(UINT32 ulY)                                        { m_cSrcRect.SetY(ulY);                }
    void SetSrcWidth(UINT32 ulW)                                    { m_cSrcRect.SetWidth(ulW);            }
    void SetSrcHeight(UINT32 ulH)                                   { m_cSrcRect.SetHeight(ulH);           }
    void SetStartSrcX(UINT32 ulX)                                   { m_cStartSrcRect.SetX(ulX);           }
    void SetStartSrcY(UINT32 ulY)                                   { m_cStartSrcRect.SetY(ulY);           }
    void SetStartSrcWidth(UINT32 ulW)                               { m_cStartSrcRect.SetWidth(ulW);       }
    void SetStartSrcHeight(UINT32 ulH)                              { m_cStartSrcRect.SetHeight(ulH);      }
    void SetStartDstRect(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH) { m_cStartDstRect.Set(ulX, ulY, ulW, ulH);  }
    void SetStartDstRect(const PXRect &rRect)                            { m_cStartDstRect = rRect;                  }
    void SetStartSrcRect(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH) { m_cStartSrcRect.Set(ulX, ulY, ulW, ulH);  }
    void SetStartSrcRect(const PXRect &rRect)                            { m_cStartSrcRect = rRect;                  }
    void SetURL(const char *pszURL)                                 { if (pszURL) m_cURL = pszURL;         }
    void SetURL(const CHXString &rURL)                              { m_cURL = rURL;                       }
    void SetColor(const PXColor &rColor)                            { m_cColor = rColor;                   }
    void SetColor(BYTE ucR, BYTE ucG, BYTE ucB)                     { m_cColor.Set(ucR, ucG, ucB);         }
    void SetColor(UINT32 ulColor)                                   { m_cColor.Set(ulColor);               }
    void SetFirstUse(BOOL bFirstUse)                                { m_bFirstUse = bFirstUse;             }
    void SetLastUse(BOOL bLastUse)                                  { m_bLastUse  = bLastUse;              }
    void SetDisplayImmediately(BOOL bFlag)                          { m_bDisplayImmediately = bFlag;       }
    void SetExFxPackage(const CHXString &rPackage)                  { m_cPackage = rPackage;               }
    void SetExFxPackage(const char *pszPackage)                     { if (pszPackage) m_cPackage = pszPackage; }
    void SetExFxName(const CHXString &rName)                        { m_cName = rName;                     }
    void SetExFxName(const char *pszName)                           { if (pszName) m_cName = pszName;      }
    void SetExFxData(const CHXString &rData)                        { m_cData = rData;                     }
    void SetExFxData(const char *pszData)                           { if (pszData) m_cData = pszData;      }
    void SetExFxFile(const CHXString &rFile)                        { m_cFile = rFile;                     }
    void SetExFxFile(const char *pszFile)                           { if (pszFile) m_cFile = pszFile;      }
    void SetHandle(UINT32 ulHandle)                                 { m_ulHandle = ulHandle;               }
    void SetCenterFlag(BOOL bFlag)                                  { m_bCenterFlag = bFlag;               }
    void SetSendTime(UINT32 ulSendTime)                             { m_ulSendTime = ulSendTime;           }
    void SetStartSendTime(INT32 lStartSendTime)                     { m_lStartSendTime = lStartSendTime;   }
    void SetPostBackChannel(BOOL bFlag)                             { m_bPostBackChannel = bFlag;          }

    UINT32 PackedSize(UINT32 ulMajVer, UINT32 ulMinVer);
    void   Pack(BYTE*& pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);
    void   UnPack(BYTE*& pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);
    BOOL   IsOverlapped(PXEffect* pEffect);
protected:
    // Effect-parameter related members
    BYTE      m_ucEffectType;
    UINT32    m_ulStart;
    UINT32    m_ulDuration;
    BOOL      m_bHasTarget;
    UINT32    m_ulTarget;
    PXRect    m_cSrcRect;
    PXRect    m_cDstRect;
    UINT32    m_ulMaxFps;
    BOOL      m_bAspectFlag;
    PXColor   m_cColor;
    BYTE      m_ucWipeDirection;
    BYTE      m_ucWipeType;
    CHXString m_cURL;
    CHXString m_cPackage;
    CHXString m_cName;
    CHXString m_cData;
    CHXString m_cFile;
    BOOL      m_bFirstUse;
    BOOL      m_bLastUse;
    BOOL      m_bDisplayImmediately;
    PXRect    m_cStartSrcRect;
    PXRect    m_cStartDstRect;
    BOOL      m_bCenterFlag;
    BOOL      m_bPostBackChannel;
    // Object-state-related members
    UINT32    m_ulHandle;
    // Scheduling-related members
    UINT32    m_ulSendTime;
    INT32     m_lStartSendTime;
};

inline void PXEffect::SetEffectType(BYTE ucEffectType)
{
    // Set effect type
    m_ucEffectType = ucEffectType;
    // If we are a <fill> or <fadein>, then we don't
    // have an target image. Otherwise, we do.
    if (m_ucEffectType == kEffectTypeFill ||
        m_ucEffectType == kEffectTypeFadeOut)
    {
        m_bHasTarget = FALSE;
    }
    else
    {
        m_bHasTarget = TRUE;
    }
}

inline HXxRect PXEffect::GetSrcHXxRect() const
{
    HXxRect cRet;
    cRet.left   = (INT32) m_cSrcRect.GetX();
    cRet.top    = (INT32) m_cSrcRect.GetY();
    cRet.right  = (INT32) m_cSrcRect.GetX() + m_cSrcRect.GetWidth();
    cRet.bottom = (INT32) m_cSrcRect.GetY() + m_cSrcRect.GetHeight();
    return cRet;                   
}

inline HXxRect PXEffect::GetDstHXxRect() const
{
    HXxRect cRet;
    cRet.left   = (INT32) m_cDstRect.GetX();
    cRet.top    = (INT32) m_cDstRect.GetY();
    cRet.right  = (INT32) m_cDstRect.GetX() + m_cDstRect.GetWidth();
    cRet.bottom = (INT32) m_cDstRect.GetY() + m_cDstRect.GetHeight();
    return cRet;                   
}

#endif

