/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpparser.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef RPPARSER_H
#define RPPARSER_H

#define REALPIX_STRICTNESS_LOW     0  // legacy errors pass through, no warnings
#define REALPIX_STRICTNESS_MEDIUM  1  // legacy errors pass through, logged as warnings
#define REALPIX_STRICTNESS_HIGH    2  // legacy errors thrown as errors

class PXRealPixParser : public CHXBaseCountingObject,
                        public CUnknownIMP,
                        public IHXXMLParserResponse
{
    DECLARE_UNKNOWN(PXRealPixParser)
public:
    // PXRealPixParser methods
    STDMETHOD(Init)                        (THIS_ IUnknown*        pContext,
                                                  PXRealPixFile*   pRealPixFile,
                                                  UINT32           ulStrictnessLevel);
    STDMETHOD(Parse)                       (THIS_ IHXBuffer*      pFileBuffer,
                                                  BOOL             bIsFinal,
                                                  REF(IHXBuffer*) rpErrorText);

    // IHXXMLParserResponse methods
    STDMETHOD(HandleStartElement)          (THIS_ const char* pName,
                                                  IHXValues* pAttributes,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleEndElement)            (THIS_ const char* pName,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleCharacterData)         (THIS_ IHXBuffer* pBuffer,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleProcessingInstruction) (THIS_ const char* pTarget,
                                                  IHXValues* pAttributes,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleUnparsedEntityDecl)    (THIS_ const char* pEntityName,
                                                  const char* pSystemID,
                                                  const char* pPublicID,
                                                  const char* pNotationName,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleNotationDecl)          (THIS_ const char* pNotationName,
                                                  const char* pSystemID,
                                                  const char* pPublicID,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumNumber);
    STDMETHOD(HandleComment)               (THIS_ const char* pComment,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleUnparsedDoctypeDecl)   (THIS_ const char* pDoctype,
                                                  const char* pSystemID,
                                                  const char* pPublicID,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
    STDMETHOD(HandleDefault)               (THIS_ IHXBuffer* pBuffer,
                                                  UINT32      ulLineNumber,
                                                  UINT32      ulColumnNumber);
protected:
    PXRealPixParser();
    virtual ~PXRealPixParser();

    enum
    {
        kTagRoot,
        kTagHead,
        kTagImage,
        kTagFill,
        kTagFadein,
        kTagCrossfade,
        kTagFadeout,
        kTagWipe,
        kTagAnimate,
        kTagViewchange,
        kTagEffect,
        kNumTags  // This should always be last in the enum
    };

    enum
    {
        kAttrWidth,
        kAttrHeight,
        kAttrBitrate,
        kAttrTimeformat,
        kAttrVersion,
        kAttrTitle,
        kAttrAuthor,
        kAttrCopyright,
        kAttrBackgroundcolor,
        kAttrBackgroundOpacity,
        kAttrStart,
        kAttrPreroll,
        kAttrAspect,
        kAttrUrl,
        kAttrMaxfps,
        kAttrDuration,
        kAttrHandle,
        kAttrName,
        kAttrTarget,
        kAttrSrcx,
        kAttrSrcy,
        kAttrSrcw,
        kAttrSrch,
        kAttrDstx,
        kAttrDsty,
        kAttrDstw,
        kAttrDsth,
        kAttrColor,
        kAttrDirection,
        kAttrType,
        kAttrPackage,
        kAttrData,
        kAttrFile,
        kAttrStartsrcx,
        kAttrStartsrcy,
        kAttrStartsrcw,
        kAttrStartsrch,
        kAttrStartdstx,
        kAttrStartdsty,
        kAttrStartdstw,
        kAttrStartdsth,
        kAttrCenter,
        kAttrSize,
        kAttrMime,
        kNumAttr   // This should always be last in the enum
    };

    enum
    {
        kStateConstructed,
        kStateInitialized,
        kStateSawRootStart,
        kStateSawHead,
        kStateSawRootEnd
    };

    struct PXStringTable
    {
        UINT32      m_ulStringID;
        const char* m_pszString;
    };

    HX_RESULT   SetError(UINT32 ulErrorID, UINT32 ulLine, UINT32 ulCol,
                         const char* pszArg1, const char* pszArg2,
                         REF(IHXBuffer*) rpErrStr);
    HX_RESULT   ParseTag(UINT32 ulTagID, IHXValues* pAttr, UINT32 ulLine, UINT32 ulCol, REF(IHXBuffer*) rpError);
    HX_RESULT   ParseHeadTag(IHXValues* pAttr, UINT32 ulLine, UINT32 ulCol, REF(IHXBuffer*) rpError);
    HX_RESULT   ParseImageTag(IHXValues* pAttr, UINT32 ulLine, UINT32 ulCol, REF(IHXBuffer*) rpError);
    HX_RESULT   ParseEffectTag(UINT32 ulTagID, IHXValues* pAttr, UINT32 ulLine,
                               UINT32 ulCol, REF(IHXBuffer*) rpError);
    HX_RESULT   SetupLegalAttrLUT();
    HX_RESULT   SetupIDMaps();
    BOOL        IsLegalAttr(UINT32 ulTagID, const char* pszAttr);
    HX_RESULT   GetTagNameFromID(UINT32 ulTagID, REF(const char*) rpszTag);
    HX_RESULT   GetTagIDFromName(const char* pszTag, REF(UINT32) rulTagID);
    HX_RESULT   GetAttributeNameFromID(UINT32 ulAttrID, REF(const char*) rpszAttr);
    HX_RESULT   GetAttributeIDFromName(const char* pszAttr, REF(UINT32) rulAttrID);
    HX_RESULT   GetFirstRequiredAttribute(UINT32 ulTagID, REF(const char*) rpszAttr);
    HX_RESULT   GetNextRequiredAttribute(UINT32 ulTagID, REF(const char*) rpszAttr);
    HX_RESULT   CheckStringContents(IHXBuffer* pString);
    HX_RESULT   ConvertTimeValue(IHXBuffer* pValue, UINT32 ulTimeFormat, REF(UINT32) ulTime);
    HX_RESULT   ConvertBoolValue(IHXBuffer* pValue, REF(BOOL) rbValue);
    HX_RESULT   ConvertVersionValue(IHXBuffer* pValue, REF(UINT32) rulVersion);
    HX_RESULT   ConvertColorValue(IHXBuffer* pValue, REF(BYTE) rucRed,
                                  REF(BYTE) rucGreen, REF(BYTE) rucBlue);
    HX_RESULT   ConvertWipeDirectionValue(IHXBuffer* pValue, REF(BYTE) rucDir);
    HX_RESULT   ConvertWipeTypeValue(IHXBuffer* pValue, REF(BYTE) rucType);
    HX_RESULT   CheckVersion(UINT32 ulMinVersion);
    void        ReportError(const UINT8 ucSeverity, HX_RESULT lHXCode, IHXBuffer* pErrorStr);

    IUnknown*                  m_pContext;
    IHXCommonClassFactory*     m_pCommonClassFactory;
    IHXXMLParser*              m_pParser;
    PXRealPixFile*             m_pRealPixFile;
    IHXBuffer*                 m_pErrorText;
    IHXBuffer*                 m_pLegalAttrLUT;
    CHXMapStringToOb*          m_pTagToIDMap;
    CHXMapStringToOb*          m_pAttrToIDMap;
    BOOL                       m_bRealPixError;
    BYTE*                      m_pByteListCursor;
    UINT32                     m_ulState;
    PXEffect*                  m_pLastEffect;
    BOOL                       m_bVersionSpecified;
    UINT32                     m_ulStrictnessLevel;

    static const PXStringTable m_pTagTable[];
    static const PXStringTable m_pAttrTable[];
    static const BYTE          m_pAttrList[];
    static const BYTE          m_pRequiredAttrList[];
    static const UINT32        m_ulHighestSupportedContentVersion;
};

#endif
