/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxutil.cpp,v 1.2.24.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// From include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxresult.h"
#include "ihxpckts.h"

// From hxcont
#include "hxstring.h"
#include "hxbuffer.h"

// From pxcomlib
#include "gstring.h"
#include "pxutil.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

void Pack32(BYTE * &pBuffer, UINT32 ulValue)
{
    pBuffer[0] = (unsigned char) ((ulValue >> 24) & 0x000000FF);
    pBuffer[1] = (unsigned char) ((ulValue >> 16) & 0x000000FF);
    pBuffer[2] = (unsigned char) ((ulValue >>  8) & 0x000000FF);
    pBuffer[3] = (unsigned char) ( ulValue        & 0x000000FF);
    pBuffer   += 4;
};

void UnPack32(BYTE * &pBuffer, UINT32 &rulValue)
{
    rulValue = ((pBuffer[0] << 24) & 0xFF000000) |
               ((pBuffer[1] << 16) & 0x00FF0000) |
               ((pBuffer[2] <<  8) & 0x0000FF00) |
               ( pBuffer[3]        & 0x000000FF);
    pBuffer += 4;
};

void Pack16(BYTE * &pBuffer, UINT16 usValue)
{
    pBuffer[0] = (unsigned char) ((usValue >> 8) & 0x00FF);
    pBuffer[1] = (unsigned char) ( usValue       & 0x00FF);
    pBuffer   += 2;
};

void UnPack16(BYTE * &pBuffer, UINT16 &rusValue)
{
    rusValue = ((pBuffer[0] << 8) & 0xFF00) |
               ( pBuffer[1]       & 0x00FF);
    pBuffer += 2;

};

void Pack8(BYTE * &pBuffer, BYTE ucValue)
{
    pBuffer[0] = ucValue;
    pBuffer++;
};

void UnPack8(BYTE * &pBuffer, BYTE &rucValue)
{
    rucValue = pBuffer[0];
    pBuffer++;
};

void PackBool(BYTE * &pBuffer, BOOL bValue)
{
    if (bValue)
    {
        Pack8(pBuffer, 1);
    }
    else
    {
        Pack8(pBuffer, 0);
    }
};

void UnPackBool(BYTE * &pBuffer, BOOL &rbValue)
{
    BYTE ucTmp;
    UnPack8(pBuffer, ucTmp);
    rbValue = (ucTmp ? TRUE : FALSE);
};

void PackString(BYTE * &pBuffer, const GString &rString)
{
    Pack16(pBuffer, (UINT16) rString.length());
    if (rString.length() > 0)
    {
//        memcpy(pBuffer, (BYTE *) rString.c_str(), rString.length());
//        pBuffer += rString.length();
        strcpy((char *) pBuffer, rString.c_str());
        pBuffer += rString.length() + 1;
    }
};

void UnPackString(BYTE * &pBuffer, GString &rString)
{
    UINT16 usLength;
    UnPack16(pBuffer, usLength);
    if (usLength > 0)
    {
        rString.CopyN(pBuffer, (UINT32) usLength);
//        pBuffer += (UINT32) usLength;
        pBuffer += (UINT32) (usLength + 1);
    }
};

void PackStringNoNullTerm(BYTE * &pBuffer, const GString &rString)
{
    Pack16(pBuffer, (UINT16) rString.length());
    if (rString.length() > 0)
    {
        memcpy(pBuffer, (BYTE *) rString.c_str(), rString.length()); /* Flawfinder: ignore */
        pBuffer += rString.length();
    }
};

void UnPackStringNoNullTerm(BYTE * &pBuffer, GString &rString)
{
    UINT16 usLength;
    UnPack16(pBuffer, usLength);
    if (usLength > 0)
    {
        rString.CopyN(pBuffer, (UINT32) usLength);
        pBuffer += (UINT32) usLength;
    }
};

void PackString(BYTE * &pBuffer, const CHXString &rString)
{
    Pack16(pBuffer, (UINT16) rString.GetLength());
    if (rString.GetLength() > 0)
    {
        strcpy((char *) pBuffer, (const char *) rString); /* Flawfinder: ignore */
        pBuffer += rString.GetLength() + 1;
    }
};

void UnPackString(BYTE * &pBuffer, CHXString &rString)
{
    UINT16 usLength;
    UnPack16(pBuffer, usLength);
    if (usLength > 0)
    {
        rString = (const char *) pBuffer;
        pBuffer += (UINT32) (usLength + 1);
    }
};

void PackStringNoNullTerm(BYTE * &pBuffer, const CHXString &rString)
{
    Pack16(pBuffer, (UINT16) rString.GetLength());
    if (rString.GetLength() > 0)
    {
        memcpy((void*) pBuffer, (const char*) rString, rString.GetLength()); /* Flawfinder: ignore */
        pBuffer += rString.GetLength();
    }
};

void UnPackStringNoNullTerm(BYTE * &pBuffer, CHXString &rString)
{
    UINT16 usLength;
    UnPack16(pBuffer, usLength);
    if (usLength > 0)
    {
        CHXString cTmp((const char*) pBuffer, (int) usLength);
        rString  = cTmp;
        pBuffer += (UINT32) usLength;
    }
};

void PackStringBuffer(BYTE * &pBuffer, IHXBuffer* pIHXBuffer)
{
    if (pIHXBuffer)
    {
        UINT32 ulLen = (UINT32) strlen((const char*) pIHXBuffer->GetBuffer());
        Pack16(pBuffer, (UINT16) ulLen);
        if (ulLen > 0)
        {
            strcpy((char*) pBuffer, (const char*) pIHXBuffer->GetBuffer()); /* Flawfinder: ignore */
            pBuffer += ulLen + 1;
        }
    }
    else
    {
        Pack16(pBuffer, (UINT16) 0);
    }
}

HX_RESULT UnPackStringBuffer(BYTE * &pBuffer, IHXBuffer** ppIHXBuffer)
{
    HX_RESULT   retVal = HXR_OK;

    UINT16 usLength = 0;
    UnPack16(pBuffer, usLength);

    if (usLength > 0)
    {
        IHXBuffer* pBuf   = (IHXBuffer*) new CHXBuffer();
        if (pBuf)
        {
            pBuf->AddRef();
            retVal = pBuf->Set(pBuffer, (UINT32) usLength + 1);
            if (SUCCEEDED(retVal))
            {
                pBuffer      += usLength + 1;
                *ppIHXBuffer = pBuf;
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }

    return retVal;
}

HX_RESULT UnPackStringBufferNoNullTerm(BYTE * &pBuffer, IHXBuffer** ppIHXBuffer)
{
    HX_RESULT   retVal = HXR_OK;

    UINT16 usLength = 0;
    UnPack16(pBuffer, usLength);

    if (usLength > 0)
    {
        IHXBuffer* pBuf   = (IHXBuffer*) new CHXBuffer();
        if (pBuf)
        {
            pBuf->AddRef();
            retVal = pBuf->Set(pBuffer, (UINT32) usLength);
            if (SUCCEEDED(retVal))
            {
                pBuffer      += usLength;
                *ppIHXBuffer = pBuf;
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }

    return retVal;
}
