/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: maasurf.h,v 1.2.34.1 2004/07/09 01:58:44 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MUNIXSURF_H_
#define _MUNIXSURF_H_

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/keysym.h>

#include "minisurf.h"

// Here is a little site I did as an example of a replacement site. It
// shows how you can tailor the mini site to output to just about any
// kind of device. This one outputs all the RGB and video in Ascii Art! 
// :) It is just a wrapper, basically, around the very nice AALib,
// which you need to have installed:
//    http://aa-project.sourceforge.net/aalib
//
class CMiniUnixSurface : public CMiniBaseSurface
{
  public:
    CMiniUnixSurface(IUnknown* pContext, CMiniBaseSite* pSite);
    virtual ~CMiniUnixSurface();
    
    virtual HX_RESULT _CreateDestBuffer(int cidIn, int nWidth, int nHeight, int& nCount); 
                     
    virtual HX_RESULT _LockDestBuffer(UCHAR** ppDestPtr,
                                      LONG32* pnDestPitch,
                                      int& cid,
                                      REF(HXxSize) srcSize,
                                      int nIndex=0);
                     
    virtual HX_RESULT _TransferToDestBuffer(UCHAR* pSrcBuffer,
                                            HXBitmapInfoHeader* pBitmapInfo,
                                            HXxRect* prSrcRect,
                                            HXxRect* prDstRect,
                                            UCHAR* pDstBuffer,
                                            LONG32 nDstPitch);
                     
    virtual HX_RESULT _UnlockDestBuffer(UCHAR* pSurfPtr, int nIndex=0);
    virtual HX_RESULT _RenderDestBuffer(HXxRect* prSrcRect,
                                        HXxRect* prDstRect,
                                        int nIndex=0);
    
    virtual HX_RESULT _DestroyDestBuffer(int cid, int nCount=1); 

    virtual HX_RESULT _init();


  protected:

    virtual int GetDstCID(int nIndex=0);

  private:

    aa_context*               m_context;
    aa_renderparams           m_render_params;
    int                       m_nAAScale;
    int                       m_nWidth;
    int                       m_nHeight;
    struct aa_hardware_params m_hardware_params;
    
    HX_RESULT _ResizeVideoBuffer( INT32 nSize);

};

#endif //_MUNIXSURF_H_
