/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: gimage.cpp,v 1.1.24.1 2004/07/09 01:53:52 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "ihxpckts.h"
#include "hxcomm.h"

// pnmisc
#include "unkimp.h"
#include "baseobj.h"

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE
static char HX_THIS_FILE[] = __FILE__;
#endif

// pxjpgrnd
#include "gimage.h"

BEGIN_INTERFACE_LIST(GImage)
END_INTERFACE_LIST

GImage::GImage(IHXCommonClassFactory *pFactory)
{
    m_pFactory        = pFactory;
    m_pImageStore     = NULL;
    m_pImageBuffer    = NULL;
    m_ulWidth         = 0;
    m_ulHeight        = 0;
    m_ulBytesPerPixel = 0;
    m_ulRowStride     = 0;

    if (m_pFactory)
    {
        m_pFactory->AddRef();
    }
}
    
GImage::~GImage()
{
    HX_RELEASE(m_pFactory);
    HX_RELEASE(m_pImageStore);
}

void GImage::SetFactory(IHXCommonClassFactory *pFactory)
{
    HX_RELEASE(m_pFactory);
    m_pFactory = pFactory;
    if (m_pFactory)
    {
        m_pFactory->AddRef();
    }
}

HX_RESULT GImage::Init(UINT32 ulW, UINT32 ulH, UINT32 ulBytes, UINT32 ulStride)
{
    // Check for input error
    if (ulW      == 0 || ulW      > kMaxWidth         ||
        ulH      == 0 || ulH      > kMaxHeight        ||
        ulBytes  == 0 || ulBytes  > kMaxBytesPerPixel ||
        ulStride == 0 || ulStride > kMaxRowStride)
    {
        return HXR_FAIL;
    }

    // Create an image store
    HX_RELEASE(m_pImageStore);
    HX_RESULT retVal = m_pFactory->CreateInstance(CLSID_IHXBuffer, (void **) &m_pImageStore);
    if (retVal != HXR_OK)
    {
        return retVal;
    }

    // Calculate the number of bytes needed in the image store
    UINT32 ulNumBytes = ulH * ulStride;

    // Set the size of the store
    retVal = m_pImageStore->SetSize(ulNumBytes);
    if (retVal != HXR_OK)
    {
        HX_RELEASE(m_pImageStore);
        return retVal;
    }

    // Set the member variables appropriately
    m_pImageBuffer    = m_pImageStore->GetBuffer();
    m_ulWidth         = ulW;
    m_ulHeight        = ulH;
    m_ulBytesPerPixel = ulBytes;
    m_ulRowStride     = ulStride;

    // Fill the memory will all zeros
    memset(m_pImageBuffer, 0, ulNumBytes);

    return HXR_OK;
}

HX_RESULT GImage::Init(const GImage &rImg, UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH)
{
    // Check to make sure input image is big enough
    if (ulX + ulW > rImg.GetWidth() || ulY + ulH > rImg.GetHeight())
    {
        return HXR_FAIL;
    }

    // Get a copy of the image store
    HX_RELEASE(m_pImageStore);
    m_pImageStore = rImg.GetImageStore();
    if (m_pImageStore)
    {
        m_pImageStore->AddRef();
    }

    // Set the member variables
    m_ulWidth         = ulW;
    m_ulHeight        = ulH;
    m_ulBytesPerPixel = rImg.GetBytesPerPixel();
    m_ulRowStride     = rImg.GetRowStride();
    m_pImageBuffer    = m_pImageStore->GetBuffer() + ulY * m_ulRowStride + ulX * m_ulBytesPerPixel;

    return HXR_OK;
}
