/*
 * Copyright (c) 1998,1999,2000,2001,2002 Tal Davidson. All rights reserved.
 *
 * compiler_defines.h   (1 January 1999)
 * by Tal Davidson (davidsont@bigfoot.com)
 * This file is a part of "Artistic Style" - an indentater and reformatter
 * of C, C++, C# and Java source files.
 *
 * The "Artistic Style" project, including all files needed to compile it,
 * is free software; you can redistribute it and/or use it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.
 */


#ifndef ASBEAUTIFIER_H
#define ASBEAUTIFIER_H

#include "ASResource.h"
#include "compiler_defines.h"
#include "ASSourceIterator.h"

#include <string>
#include <vector>


using namespace std;

namespace astyle
  {

  enum BracketMode   { NONE_MODE, ATTACH_MODE, BREAK_MODE, BDAC_MODE };
  enum BracketType   { NULL_TYPE = 0,
                       DEFINITION_TYPE = 1,
                       COMMAND_TYPE = 2,
                       ARRAY_TYPE  = 4,
                       SINGLE_LINE_TYPE = 8};


  class ASBeautifier : protected ASResource
    {
    public:
      ASBeautifier();
      virtual ~ASBeautifier();
      virtual void init(ASSourceIterator* iter); // pointer to dynamically created iterator.
      virtual void init();
      virtual bool hasMoreLines() const;
      virtual string nextLine();
      virtual string beautify(const string &line);
      void setTabIndentation(int length = 4, bool forceTabs = false);
      void setSpaceIndentation(int length = 4);
      void setMaxInStatementIndentLength(int max);
      void setMinConditionalIndentLength(int min);
      void setClassIndent(bool state);
      void setSwitchIndent(bool state);
      void setCaseIndent(bool state);
      void setBracketIndent(bool state);
      void setBlockIndent(bool state);
      void setNamespaceIndent(bool state);
      void setLabelIndent(bool state);
      void setCStyle();
      void setJavaStyle();
      void setEmptyLineFill(bool state);
      void setPreprocessorIndent(bool state);


    protected:
      int getNextProgramCharDistance(const string &line, int i);
      bool isLegalNameChar(char ch) const;
      bool isWhiteSpace(char ch) const;
      const string *findHeader(const string &line, int i,
                               const vector<const string*> &possibleHeaders,
                               bool checkBoundry = true);
      string trim(const string &str);
      int indexOf(vector<const string*> &container, const string *element);

    private:
      ASBeautifier(const ASBeautifier &copy);
      void operator=(ASBeautifier&); // not to be implemented

      void initStatic();
      void registerInStatementIndent(const string &line, int i, int spaceTabCount,
                                     int minIndent, bool updateParenStack);
      string preLineWS(int spaceTabCount, int tabCount);

      static vector<const string*> headers;
      static vector<const string*> nonParenHeaders;
      static vector<const string*> preprocessorHeaders;
      static vector<const string*> preBlockStatements;
      static vector<const string*> assignmentOperators;
      static vector<const string*> nonAssignmentOperators;

      static bool calledInitStatic;

      ASSourceIterator *sourceIterator;
      vector<ASBeautifier*> *waitingBeautifierStack;
      vector<ASBeautifier*> *activeBeautifierStack;
      vector<int> *waitingBeautifierStackLengthStack;
      vector<int> *activeBeautifierStackLengthStack;
      vector<const string*> *headerStack;
      vector< vector<const string*>* > *tempStacks;
      vector<int> *blockParenDepthStack;
      vector<bool> *blockStatementStack;
      vector<bool> *parenStatementStack;
      vector<int> *inStatementIndentStack;
      vector<int> *inStatementIndentStackSizeStack;
      vector<int> *parenIndentStack;
      vector<bool> *bracketBlockStateStack;
      string indentString;
      const string *currentHeader;
      const string *previousLastLineHeader;
      const string *immediatelyPreviousAssignmentOp;
      const string *probationHeader;
      bool isInQuote;
      bool isInComment;
      bool isInCase;
      bool isInQuestion;
      bool isInStatement;
      bool isInHeader;
      bool isCStyle;
      bool isInOperator;
      bool isInTemplate;
      bool isInConst;
      bool isInDefine;
      bool isInDefineDefinition;
      bool classIndent;
      bool isInClassHeader;
      bool isInClassHeaderTab;
      bool switchIndent;
      bool caseIndent;
      bool namespaceIndent;
      bool bracketIndent;
      bool blockIndent;
      bool labelIndent;
      bool preprocessorIndent;
      bool isInConditional;
      bool isMinimalConditinalIndentSet;
      bool shouldForceTabIndentation;
      int minConditionalIndent;
      int parenDepth;
      int indentLength;
      int blockTabCount;
      unsigned int leadingWhiteSpaces;
      int maxInStatementIndent;
      int templateDepth;
      char quoteChar;
      char prevNonSpaceCh;
      char currentNonSpaceCh;
      char currentNonLegalCh;
      char prevNonLegalCh;
      int prevFinalLineSpaceTabCount;
      int prevFinalLineTabCount;
      bool emptyLineFill;
      bool backslashEndsPrevLine;
      int defineTabCount;
    };
}

#endif
