/***************************************************************************
                          stringtools.h  -  description
                             -------------------
    begin                : Mon Dec 10 2001
    copyright            : (C) 2001 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STRINGTOOLS_H
#define STRINGTOOLS_H

#include <string>

using namespace std;

/**\brief Contains methods for string manipulation
  *@author Andre Simon
  */

namespace StringTools
  {

  /** \param s String
      \returns lowercase string  */
  string lowerCase(const string &s);

  /** \param s String
      \returns Integer value */
  int str2int(string s);

  /** \return true if c is alpa or underscore */
  bool isAlpha(unsigned char c);

  /** \param value String
     \return string trimmed on the left side
  */
  string trimRight(const string &value);

  /** \return next character in line starting from index, which is no whitespace*/
  unsigned char getNextNonWs(const string &line, int index=0);

  /** \param s String, containing a opening and a closing paranthesis
       \return value between "(", ")" */
  string getParantheseVal(const string &s);

}

#endif
