/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* Updating the start/end addresses */

/* Functionality update_adr_up:       ( start ----> end )

      memstartadr += memstartinc;

      procstartautonom = mem2proc( memstartadr );
      procendautonom = procstartautonom + procautonomrange;

      if ( procendautonom > procendadr )
        procendautonom = procendadr;
      if ( memstartadr > memendadr )
        stop test               (normal end. Ex: fast-y 09-31)
      if ( procstartautonom < procstartadr )
        stop test               (abnormal: wrong start/end. Ex: fast-x 09-32)
      if ( procstartautonom > procendadr )
        stop test               (abnormal: wrong start/end. Ex: fast-y 09-0E)

      ret

   Then test from procstartautonom up to procendautonom (both inclusive)
   with increment autonominc.

   Variables:

      %eax = procstartautonom = proc-adr address pointer in test
      %ebx = autonominc = increment of %eax during autonomous testing
           = 0000001000 (bin)
                   |
                   first bit of autonomous range (proc-adr)
      %esi = memstartadr = mem-adr start of current autonomous range
      %edi = procendautonom = last proc-adr of current autonomous range

      procstartadr (mutating) = first proc-adr of area-under-test
      procendadr (mutating) = last proc-adr of area-under-test
      memendadr (mutating) = mem-adr end of area-under-test
      memstartinc (mutating) = increment of %esi between autonomous parts
                             = 0000100000 (bin)
                                    |
                                    last bit of autonomous range (mem-adr)
      procautonomrange (mutating) = "range"/"length" of autonomous part
                                  = 0000001110 (bin)
                                          | |
                                          | first bit,
                                          last bit of autonom. range (proc-adr)

   The "autonomous range" is the right-most range of "in-sequence" bits in
   the proc-adr bit list.

   Ex: fast-x with addressline scheme

      2 1 0 4 3 5   <- proc-adr
                ~
      5 4 3 2 1 0   <- mem-adr

   has antonomous range = only bit #5 (proc-adr)
                        = only bit #0 (mem-adr)

   so  autonominc       = bit #5 = 100000
       memstartinc      = bit #1 = 000010
       procautonomrange = bit #6 = 100000

   The tests make sure that no single byte outside the area-under-test
   is addressed.
   Since procautonomrange >= 0 is always procstartautonom <= procendautonom.
   The following situations are possible ("|    |" is area-under-test,
   delimited by procstartadr and procendadr, "S" is procstartautonom,
   "E" is procendautonom):

   procstartautonom <= procendautonom <= procstartadr <= procendadr
     S E |       |        is caught, test stops.

   procstartautonom <= procstartadr <= procendautonom <= procendadr
     S   |     E |        is caught, test stops.

   procstartautonom <= procstartadr <= procendadr <= procendautonom
     S   |       |   E    is caught, test stops.

   procstartadr <= procstartautonom <= procendautonom <= procendadr
         | S   E |        is the normal situation.

   procstartadr <= procstartautonom <= procendadr <= procendautonom
         | S     |   E    can occur, procendautonom is reset to procendadr

   procstartadr <= procendadr <= procstartautonom <= procendautonom
         |       | S E    is caught, test stops.


   BEFORE THE TEST, values should be initialized:

      memstartadr = proc2mem( procstartadr ) & memnonautonommask;
      memendadr = proc2mem( procendadr );

      call update_adr_up but without the memstartadr increment
      (ignore errors)

      procstartautonom = procstartadr;     (override)

   Variable:

      memnonautonommask = mask that selects bits of memstartadr that are
                          not updated autonomously.
                        = 1111110000
                                |
                                last bit of autonomous range (mem-adr)

*/

/* Functionality update_adr_dn:       (note: end <---- start )

      memstartadr -= memstartdec;

      procstartautonom = mem2proc( memstartadr );
      procendautonom = procstartautonom - procautonomrange;

      if ( procendautonom < procendadr )
        procendautonom = procendadr;
      if ( memstartadr < memendadr )
        stop test               (normal end. Ex: fast-y 31-09)
      if ( procstartautonom > procstartadr )
        stop test               (abnormal: wrong start/end. Ex: fast-x 32-09)
      if ( procstartautonom < procendadr )
        stop test               (abnormal: wrong start/end. Ex: fast-y 2E-29)

      ret

   Then test from procstartautonom down to procendautonom (both inclusive)
   with decrement autonomdec.

   Variables:

      %eax = procstartautonom = proc-adr address pointer in test
      %ebx = autonomdec = decrement of %eax during autonomous testing
           = 0000001000 (bin)
                   |
                   first bit of autonomous range (proc-adr)
      %esi = memstartadr = mem-adr start of current autonomous range
      %edi = procendautonom = last proc-adr of current autonomous range

      procstartadr (mutating) = first (=highest) proc-adr of area-under-test
      procendadr (mutating) = last (=lowest) proc-adr of area-under-test
      memendadr (mutating) = mem-adr end of area-under-test
      memstartdec (mutating) = decrement of %esi between autonomous parts
                             = 0000100000 (bin)
                                    |
                                    last bit of autonomous range (mem-adr)
      procautonomrange (mutating) = "range"/"length" of autonomous part
                                  = 0000001110 (bin)
                                          | |
                                          | first bit,
                                          last bit of autonom. range (proc-adr)

   The "autonomous range" is the right-most range of "in-sequence" bits in
   the proc-adr bit list.

   Ex: fast-x with addressline scheme

      2 1 0 4 3 5   <- proc-adr
                ~
      5 4 3 2 1 0   <- mem-adr

   has antonomous range = only bit #5 (proc-adr)
                        = only bit #0 (mem-adr)

   so  autonomdec       = bit #5 = 100000
       memstartdec      = bit #1 = 000010
       procautonomrange = bit #5 = 100000

   The tests make sure that no single byte outside the area-under-test
   is addressed.
   Since procautonomrange >= 0 is always procendautonom <= procstartautonom.
   The following situations are possible ("|    |" is area-under-test,
   delimited by procstartadr and procendadr, "S" is procstartautonom,
   "E" is procendautonom):

   procendadr <= procstartadr <= procendautonom <= procstartautonom
         |       | E S    is caught, test stops.

   procendadr <= procendautonom <= procstartadr <= procstartautonom
         | E     |   S    is caught, test stops.

   procendautonom <= procendadr <= procstartadr <= procstartautonom
     E   |       |   S    is caught, test stops.

   procendadr <= procendautonom <= procstartautonom <= procstartadr
         | E   S |        is the normal situation.

   procendautonom <= procendadr <= procstartautonom <= procstartadr
     E   |     S |        can occur, procendautonom is reset to procendadr

   procendautonom <= procstartautonom <= procendadr <= procstartadr
     E S |       |        is caught, test stops.


   BEFORE THE TEST, values should be initialized:

      memstartadr = proc2mem( procstartadr ) | memautonommask;
      memendadr = proc2mem( procendadr );

      call update_adr_dn but without the memstartadr decrement
      (ignore errors)

      procstartautonom = procstartadr;     (override)

   Variable:

      memautonommask = mask that selects bits of memstartadr that are
                       updated autonomously.
                     = 0000001111
                             |
                             last bit of autonomous range (mem-adr)

*/



#include "defines.h"

.text

/****************************************************************************
 * Region that is filled with the correct code
 */

.globl update_adr_start
.globl update_adr

.align 16

update_adr_start:
	.fill 32

update_adr:
	.fill ADRCODE_LEN


/****************************************************************************
 * Template for UP
 *
 * NOTE: DON'T CHANGE THIS WITHOUT CHECKING update_adr.c !!
 */

.globl update_adr_up_startB		/* B=Begin, E=End */
.globl update_adr_up_startE
.globl update_adr_upB1
.globl update_adr_upE1
.globl update_adr_upB2
.globl update_adr_upE2
.globl update_adr_upB3
.globl update_adr_upE3

.align 32				/* Use 32 here because for this part
					   32 bytes are reserved, and we
					   want to make sure the next part
					   really starts 32 bytes below. */
update_adr_up_startB:			/* Sets: eax, ebx, esi, edi */
					/* Uses: edx */
					/* Not touched: ecx, ebp */

	movl  $0x10000000, %esi		/* start value of memstartadr, */
	movl  $0x10000000, %ebx		/* autonominc */

	call  update_adr_up_startshuf	/* sets eax and edi=procendautonom */

	movl  $0x10000000, %eax		/* reset eax=procstartautonom to */
					/* the value it should have */
	ret

update_adr_up_startE:

.align 32, 0xc3  			/* `as' normally uses "long NOPs" */

update_adr_upB1:			/* "Header": */

	addl  $0x10000000, %esi		/* memstartadr += memstartinc */

update_adr_up_startshuf:		/* procstartautonom = 
					   mem2proc( memstartadr ) */

	xorl  %eax, %eax		/* Clear procstartautonom */

update_adr_upE1:
.align 16, 0xc3
update_adr_upB2:			/* Repeating part: */

	movl  $0x10000000, %edx		/* Load bit mask #n */
	andl  %esi, %edx		/* Extract bit from memstartadr */
	shll  $1, %edx			/* Shift bit to correct position */
	orl   %edx, %eax		/* Set bit of procstartautonom */

update_adr_upE2:
.align 16, 0xc3
update_adr_upB3:			/* "Footer": */

	movl  %eax, %edi		/* procendautonom = procstartautonom */
	addl  $0x10000000, %edi		/*    + procautonomrange */

	cmpl  $0x10000000, %edi		/* if procendautonom > procendadr */
	ja    update_adr_up_endtoohigh  /* then correct it */
					/* Note: branch prediction: NOT taken*/
update_adr_up_endtoohighret:

	cmpl  $0x10000000, %esi		/* if memstartadr > memendadr */
	ja    update_adr_up_stoptest    /* then stop test */

	cmpl  $0x10000000, %eax		/* if procstartautonom < procstartadr*/
	jb    update_adr_up_stoptest    /* then stop test */

	cmpl  $0x10000000, %eax		/* if procstartautonom > procendadr */
	ja    update_adr_up_stoptest    /* then stop test */

	clc				/* All okay: clear carry */
	ret


update_adr_up_endtoohigh:
	movl  $0x10000000, %edi		/*   procendautonom = procendadr */
        jmp   update_adr_up_endtoohighret

update_adr_up_stoptest:
	stc				/*   stop test: set carry */
	ret

update_adr_upE3:

	nop


/****************************************************************************
 * Template for DOWN
 *
 * NOTE: DON'T CHANGE THIS WITHOUT CHECKING update_adr.c !!
 */

.globl update_adr_dn_startB		/* B=Begin, E=End */
.globl update_adr_dn_startE
.globl update_adr_dnB1
.globl update_adr_dnE1
.globl update_adr_dnB2
.globl update_adr_dnE2
.globl update_adr_dnB3
.globl update_adr_dnE3

.align 32				/* Use 32 here because for this part
					   32 bytes are reserved, and we
					   want to make sure the next part
					   really starts 32 bytes below. */
update_adr_dn_startB:			/* Sets: eax, ebx, esi, edi */
					/* Uses: edx */
					/* Not touched: ecx, ebp */

	movl  $0x10000000, %esi		/* start value of memstartadr, */
	movl  $0x10000000, %ebx		/* autonomdec */

	call  update_adr_dn_startshuf	/* sets eax and edi=procendautonom */

	movl  $0x10000000, %eax		/* reset eax=procstartautonom to */
					/* the value it should have */
	ret

update_adr_dn_startE:

.align 32, 0xc3  			/* `as' normally uses "long NOPs" */

update_adr_dnB1:			/* "Header": */

	subl  $0x10000000, %esi		/* memstartadr -= memstartdec */

update_adr_dn_startshuf:		/* procstartautonom = 
					   mem2proc( memstartadr ) */

	xorl  %eax, %eax		/* Clear procstartautonom */

update_adr_dnE1:
.align 16, 0xc3
update_adr_dnB2:			/* Repeating part: */

	movl  $0x10000000, %edx		/* Load bit mask #n */
	andl  %esi, %edx		/* Extract bit from memstartadr */
	shll  $1, %edx			/* Shift bit to correct position */
	orl   %edx, %eax		/* Set bit of procstartautonom */

update_adr_dnE2:
.align 16, 0xc3
update_adr_dnB3:			/* "Footer": */

	movl  %eax, %edi		/* procendautonom = procstartautonom */
	subl  $0x10000000, %edi		/*    - procautonomrange */

	cmpl  $0x10000000, %edi		/* if procendautonom < procendadr */
	jb    update_adr_dn_endtoolow	/* then correct it */
					/* Note: branch prediction: NOT taken*/
update_adr_dn_endtoolowret:

	cmpl  $0x10000000, %esi		/* if memstartadr < memendadr */
	jb    update_adr_dn_stoptest    /* then stop test */

	cmpl  $0x10000000, %eax		/* if procstartautonom > procstartadr*/
	ja    update_adr_dn_stoptest    /* then stop test */

	cmpl  $0x10000000, %eax		/* if procstartautonom < procendadr */
	jb    update_adr_dn_stoptest    /* then stop test */

	clc				/* All okay: clear carry */
	ret


update_adr_dn_endtoolow:
	movl  $0x10000000, %edi		/*   procendautonom = procendadr */
        jmp   update_adr_dn_endtoolowret

update_adr_dn_stoptest:
	stc				/*   stop test: set carry */
	ret

update_adr_dnE3:

	nop

