/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     INT = 258,
     SYSTEM = 259,
     TOPSYSTEM = 260,
     NODE = 261,
     SUBSYSTEM = 262,
     NODETYPE = 263,
     NAME = 264,
     SPEED = 265,
     WIDTH = 266,
     LINE = 267,
     CFG = 268
   };
#endif
#define INT 258
#define SYSTEM 259
#define TOPSYSTEM 260
#define NODE 261
#define SUBSYSTEM 262
#define NODETYPE 263
#define NAME 264
#define SPEED 265
#define WIDTH 266
#define LINE 267
#define CFG 268




/* Copy the first part of user declarations.  */
#line 40 "ibnl_parser.yy"


  /* header section */
#include <stdlib.h>
#include <stdio.h>
#include "SysDef.h"
#define YYERROR_VERBOSE 1

#define	yymaxdepth ibnl_maxdepth
#define	yyparse	ibnl_parse
#define	yylex	ibnl_lex
#define	yyerror	ibnl_error
#define	yylval	ibnl_lval
#define	yychar	ibnl_char
#define	yydebug	ibnl_debug
#define	yypact	ibnl_pact
#define	yyr1	ibnl_r1
#define	yyr2	ibnl_r2
#define	yydef	ibnl_def
#define	yychk	ibnl_chk
#define	yypgo	ibnl_pgo
#define	yyact	ibnl_act
#define	yyexca	ibnl_exca
#define  yyerrflag ibnl_errflag
#define  yynerrs	ibnl_nerrs
#define	yyps	ibnl_ps
#define	yypv	ibnl_pv
#define	yys	ibnl_s
#define	yy_yys	ibnl_yys
#define	yystate	ibnl_state
#define	yytmp	ibnl_tmp
#define	yyv	ibnl_v
#define	yy_yyv	ibnl_yyv
#define	yyval	ibnl_val
#define	yylloc	ibnl_lloc
#define yyreds	ibnl_reds
#define yytoks	ibnl_toks
#define yylhs	ibnl_yylhs
#define yylen	ibnl_yylen
#define yydefred ibnl_yydefred
#define yydgoto	ibnl_yydgoto
#define yysindex ibnl_yysindex
#define yyrindex ibnl_yyrindex
#define yygindex ibnl_yygindex
#define yytable	 ibnl_yytable
#define yycheck	 ibnl_yycheck
#define yyname   ibnl_yyname
#define yyrule   ibnl_yyrule

  extern int yyerror(char *msg);
  extern int yylex(void);




/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 96 "ibnl_parser.yy"
typedef union YYSTYPE {
  IBNodeType tval;
  int        ival;
  char      *sval;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 163 "ibnl_parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 111 "ibnl_parser.yy"


  static int ibnlErr;
  long lineNum;
  static const char *gp_fileName;
  static int gIsTopSystem = 0;
  static list< char * > gSysNames;
  static IBSystemsCollection *gp_sysColl = 0;
  static IBSysDef *gp_curSysDef = 0;
  static IBSysInst *gp_curInstDef = 0;

  void ibnlMakeSystem(list< char * > &sysNames) {
#ifdef DEBUG
    printf("Making new system named:");
#endif
    gp_curSysDef = new IBSysDef(gp_fileName);

    for( list< char * >::iterator snI = sysNames.begin();
         snI != sysNames.end(); snI++) {
      char sname[1024];
      if (gIsTopSystem) {
        sprintf(sname, "%s", *snI);
      } else {
        sprintf(sname, "%s/%s", gp_fileName, *snI);
      }
      string sNameStr(sname);
      gp_sysColl->addSysDef(sNameStr, gp_curSysDef);
#ifdef DEBUG
      printf("%s ", sname);
#endif
    }
#ifdef DEBUG
    printf("\n");
#endif

    // cleanup for next systems.
    sysNames.erase(sysNames.begin(), sysNames.end());
  }

  void ibnlMakeSubInstAttribute(char *hInst, char *attr, char *value) {
#ifdef DEBUG
    printf("Making new sub instance attribute inst:%s %s=%s\n",
           hInst, attr, value);
#endif
    if (! gp_curSysDef) {
        printf("-E- How com e we got no system???\n");
        exit(3);
    }
    // append to existing attr or create new
    string hierInstName = string(hInst);
    string attrStr = string(attr);
    if (value)
       attrStr += "=" +  string(value);
    gp_curSysDef->setSubInstAttr(hierInstName, attrStr);
  }

  void ibnlMakeNode(IBNodeType type, int numPorts, char *devName, char* name) {
#ifdef DEBUG
    printf(" Making Node:%s dev:%s ports:%d\n", name, devName, numPorts);
#endif
    gp_curInstDef = new IBSysInst(name, devName, numPorts, type);
    gp_curSysDef->addInst(gp_curInstDef);
  }

  void ibnlMakeNodeToNodeConn(
    int fromPort, char *width, char *speed, char *toNode, int toPort) {
#ifdef DEBUG
    printf("  Connecting N-N port:%d to Node:%s/%d (w=%s,s=%s)\n",
           fromPort, toNode, toPort, width, speed);
#endif
    char buf1[8],buf2[8] ;
    sprintf(buf1, "%d", toPort);
    sprintf(buf2, "%d", fromPort);
    IBSysInstPort *p_port =
      new IBSysInstPort(buf2, toNode, buf1, char2width(width),
                        char2speed(speed));
    gp_curInstDef->addPort(p_port);
  }

  void ibnlMakeNodeToPortConn(
    int fromPort, char *width, char *speed, char *sysPortName) {
#ifdef DEBUG
    printf("  System port:%s on port:%d (w=%s,s=%s)\n",
           sysPortName, fromPort, width, speed);
#endif
    char buf[8];
    sprintf(buf,"%d",fromPort);
    IBSysPortDef *p_sysPort =
      new IBSysPortDef(sysPortName, gp_curInstDef->getName(), buf,
                       char2width(width), char2speed(speed));
    gp_curSysDef->addSysPort(p_sysPort);
  }

  void ibnlMakeSubsystem( char *masterName, char *instName) {
#ifdef DEBUG
    printf(" Making SubSystem:%s of type:%s\n", instName, masterName);
#endif
    gp_curInstDef = new IBSysInst(instName, masterName);
    gp_curSysDef->addInst(gp_curInstDef);
  }

  void ibnlRecordModification( char *subSystem, char *modifier) {
#ifdef DEBUG
    printf("  Using modifier:%s on %s\n", modifier, subSystem);
#endif
    gp_curInstDef->addInstMod(subSystem, modifier);
  }

  void ibnlMakeSubsystemToSubsystemConn(
    char *fromPort, char *width, char *speed, char *toSystem, char *toPort) {
#ifdef DEBUG
    printf("  Connecting S-S port:%s to SubSys:%s/%s\n",
         fromPort, toSystem, toPort);
#endif
    IBSysInstPort *p_port =
      new IBSysInstPort(fromPort, toSystem, toPort, char2width(width),
                        char2speed(speed));
    gp_curInstDef->addPort(p_port);
  }

  void ibnlMakeSubsystemToPortConn(
    char *fromPort, char *width, char *speed, char *toPort) {
#ifdef DEBUG
    printf("  Connecting port:%s to SysPort:%s\n",
         fromPort, toPort);
#endif

    IBSysPortDef *p_sysPort =
      new IBSysPortDef(toPort, gp_curInstDef->getName(), fromPort,
                       char2width(width), char2speed(speed));
    gp_curSysDef->addSysPort(p_sysPort);
  }



/* Line 213 of yacc.c.  */
#line 309 "ibnl_parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  7
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   82

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  18
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  30
/* YYNRULES -- Number of rules. */
#define YYNRULES  57
/* YYNRULES -- Number of states. */
#define YYNSTATES  107

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   268

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    15,    16,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    14,    17,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     8,     9,    11,    15,    16,    19,
      20,    24,    30,    36,    40,    41,    42,    50,    51,    52,
      59,    61,    65,    67,    68,    71,    74,    78,    84,    85,
      89,    91,    93,   103,   111,   119,   125,   134,   141,   148,
     153,   157,   164,   168,   169,   172,   176,   177,   181,   183,
     185,   195,   203,   211,   217,   226,   233,   240
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      21,     0,    -1,    12,    -1,    19,    12,    -1,    -1,    19,
      -1,    20,    22,    25,    -1,    -1,    22,    28,    -1,    -1,
      23,    24,    19,    -1,     9,    14,     9,    14,     9,    -1,
       9,    14,     9,    14,     3,    -1,     9,    14,     9,    -1,
      -1,    -1,     5,    26,    31,    27,    19,    23,    33,    -1,
      -1,    -1,     4,    29,    31,    30,    19,    33,    -1,    32,
      -1,    31,    15,    32,    -1,     9,    -1,    -1,    33,    34,
      -1,    33,    40,    -1,    35,    19,    36,    -1,     6,     8,
       3,     9,     9,    -1,    -1,    36,    37,    19,    -1,    38,
      -1,    39,    -1,     3,    16,    11,    16,    10,    16,    17,
       9,     3,    -1,     3,    16,    11,    16,    17,     9,     3,
      -1,     3,    16,    10,    16,    17,     9,     3,    -1,     3,
      16,    17,     9,     3,    -1,     3,    16,    11,    16,    10,
      16,    17,     9,    -1,     3,    16,    11,    16,    17,     9,
      -1,     3,    16,    10,    16,    17,     9,    -1,     3,    16,
      17,     9,    -1,    41,    19,    44,    -1,    41,    19,    13,
      42,    19,    44,    -1,     7,     9,     9,    -1,    -1,    42,
      43,    -1,     9,    14,     9,    -1,    -1,    44,    45,    19,
      -1,    46,    -1,    47,    -1,     9,    16,    11,    16,    10,
      16,    17,     9,     9,    -1,     9,    16,    11,    16,    17,
       9,     9,    -1,     9,    16,    10,    16,    17,     9,     9,
      -1,     9,    16,    17,     9,     9,    -1,     9,    16,    11,
      16,    10,    16,    17,     9,    -1,     9,    16,    11,    16,
      17,     9,    -1,     9,    16,    10,    16,    17,     9,    -1,
       9,    16,    17,     9,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   248,   248,   249,   251,   252,   254,   256,   257,   260,
     261,   265,   266,   271,   275,   276,   275,   282,   283,   282,
     287,   288,   292,   295,   296,   297,   301,   305,   308,   309,
     313,   314,   318,   321,   324,   327,   333,   336,   339,   342,
     348,   349,   353,   356,   357,   361,   364,   365,   369,   370,
     374,   377,   380,   383,   389,   392,   395,   398
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INT", "SYSTEM", "TOPSYSTEM", "NODE",
  "SUBSYSTEM", "NODETYPE", "NAME", "SPEED", "WIDTH", "LINE", "CFG", "'='",
  "','", "'-'", "'>'", "$accept", "NL", "ONL", "ibnl", "systems",
  "sub_inst_attributes", "sub_inst_attribute", "topsystem", "@1", "@2",
  "system", "@3", "@4", "system_names", "system_name", "insts", "node",
  "node_header", "node_connections", "node_connection",
  "node_to_node_link", "node_to_port_link", "subsystem",
  "subsystem_header", "insts_modifications", "modification",
  "subsystem_connections", "subsystem_connection",
  "subsystem_to_subsystem_link", "subsystem_to_port_link", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,    61,    44,    45,    62
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    18,    19,    19,    20,    20,    21,    22,    22,    23,
      23,    24,    24,    24,    26,    27,    25,    29,    30,    28,
      31,    31,    32,    33,    33,    33,    34,    35,    36,    36,
      37,    37,    38,    38,    38,    38,    39,    39,    39,    39,
      40,    40,    41,    42,    42,    43,    44,    44,    45,    45,
      46,    46,    46,    46,    47,    47,    47,    47
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     0,     1,     3,     0,     2,     0,
       3,     5,     5,     3,     0,     0,     7,     0,     0,     6,
       1,     3,     1,     0,     2,     2,     3,     5,     0,     3,
       1,     1,     9,     7,     7,     5,     8,     6,     6,     4,
       3,     6,     3,     0,     2,     3,     0,     3,     1,     1,
       9,     7,     7,     5,     8,     6,     6,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       4,     2,     5,     7,     0,     3,     0,     1,    17,    14,
       6,     8,     0,     0,    22,    18,    20,    15,     0,     0,
       0,    21,    23,     9,    19,    23,     0,     0,    24,     0,
      25,     0,     0,     0,    16,     0,     0,    28,    46,     0,
      10,     0,    42,    26,    43,    40,    13,     0,     0,     0,
      30,    31,     0,     0,     0,    48,    49,     0,    27,     0,
      29,     0,    46,    44,     0,    47,    12,    11,     0,     0,
       0,     0,    41,     0,     0,     0,     0,     0,    39,    45,
       0,     0,    57,     0,     0,     0,    35,     0,     0,     0,
      53,    38,     0,    37,    56,     0,    55,    34,     0,    33,
      52,     0,    51,    36,    54,    32,    50
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     2,     3,     4,     6,    25,    33,    10,    13,    20,
      11,    12,    19,    15,    16,    24,    28,    29,    43,    49,
      50,    51,    30,    31,    52,    63,    45,    54,    55,    56
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -20
static const yysigned_char yypact[] =
{
      -5,   -20,     9,   -20,    25,   -20,    14,   -20,   -20,   -20,
     -20,   -20,    20,    20,   -20,    11,   -20,    11,    20,    -5,
      -5,   -20,     9,     9,    17,    22,    24,    27,   -20,    -5,
     -20,    -5,    23,    -5,    17,    31,    29,     9,    15,    30,
       9,    32,   -20,    37,   -20,    33,    34,    35,    36,    -5,
     -20,   -20,     8,    38,    -5,   -20,   -20,    13,   -20,    -8,
       9,    39,     9,   -20,    -6,     9,   -20,   -20,    40,    41,
      42,    46,    33,    43,    44,    49,    26,    -4,    47,   -20,
      28,    -2,    52,    53,    48,    54,   -20,    56,    50,    58,
     -20,    65,    55,    66,    61,    57,    62,   -20,    64,   -20,
     -20,    67,   -20,    72,    68,   -20,   -20
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -20,   -19,   -20,   -20,   -20,   -20,   -20,   -20,   -20,   -20,
     -20,   -20,   -20,    69,    60,    21,   -20,   -20,   -20,   -20,
     -20,   -20,   -20,   -20,   -20,   -20,   -15,   -20,   -20,   -20
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      22,    23,    68,    69,    73,    74,    84,     1,    88,    70,
      37,    75,    38,    85,    40,    89,    66,    61,     8,     9,
       1,     5,    67,    26,    27,     7,    18,     5,    44,    14,
      60,    32,    35,    62,    41,    65,    36,    39,    42,    46,
      48,    47,    53,    83,    58,    87,    34,    72,    57,     0,
      86,    78,    59,    71,    64,    79,    76,    77,    82,    80,
      81,    90,    91,    93,    92,    94,    95,    96,    97,    99,
     100,   102,    98,   103,   101,   105,   104,   106,    21,     0,
       0,     0,    17
};

static const yysigned_char yycheck[] =
{
      19,    20,    10,    11,    10,    11,    10,    12,    10,    17,
      29,    17,    31,    17,    33,    17,     3,     9,     4,     5,
      12,    12,     9,     6,     7,     0,    15,    12,    13,     9,
      49,     9,     8,    52,     3,    54,     9,    14,     9,     9,
       3,     9,     9,    17,     9,    17,    25,    62,    14,    -1,
       3,     9,    16,    14,    16,     9,    16,    16,     9,    16,
      16,     9,     9,     9,    16,     9,    16,     9,     3,     3,
       9,     9,    17,     9,    17,     3,     9,     9,    18,    -1,
      -1,    -1,    13
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    12,    19,    20,    21,    12,    22,     0,     4,     5,
      25,    28,    29,    26,     9,    31,    32,    31,    15,    30,
      27,    32,    19,    19,    33,    23,     6,     7,    34,    35,
      40,    41,     9,    24,    33,     8,     9,    19,    19,    14,
      19,     3,     9,    36,    13,    44,     9,     9,     3,    37,
      38,    39,    42,     9,    45,    46,    47,    14,     9,    16,
      19,     9,    19,    43,    16,    19,     3,     9,    10,    11,
      17,    14,    44,    10,    11,    17,    16,    16,     9,     9,
      16,    16,     9,    17,    10,    17,     3,    17,    10,    17,
       9,     9,    16,     9,     9,    16,     9,     3,    17,     3,
       9,    17,     9,     9,     9,     3,     9
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 11:
#line 265 "ibnl_parser.yy"
    { ibnlMakeSubInstAttribute((yyvsp[-4].sval),(yyvsp[-2].sval),(yyvsp[0].sval)); }
    break;

  case 12:
#line 266 "ibnl_parser.yy"
    {
      char buf[16];
      sprintf(buf, "%d", (yyvsp[0].ival));
      ibnlMakeSubInstAttribute((yyvsp[-4].sval),(yyvsp[-2].sval),buf);
   }
    break;

  case 13:
#line 271 "ibnl_parser.yy"
    {ibnlMakeSubInstAttribute((yyvsp[-2].sval),(yyvsp[0].sval),NULL); }
    break;

  case 14:
#line 275 "ibnl_parser.yy"
    { gIsTopSystem = 1; }
    break;

  case 15:
#line 276 "ibnl_parser.yy"
    { ibnlMakeSystem(gSysNames); }
    break;

  case 17:
#line 282 "ibnl_parser.yy"
    { gIsTopSystem = 0; }
    break;

  case 18:
#line 283 "ibnl_parser.yy"
    { ibnlMakeSystem(gSysNames); }
    break;

  case 22:
#line 292 "ibnl_parser.yy"
    { gSysNames.push_back((yyvsp[0].sval)); }
    break;

  case 27:
#line 305 "ibnl_parser.yy"
    { ibnlMakeNode((yyvsp[-3].tval),(yyvsp[-2].ival),(yyvsp[-1].sval),(yyvsp[0].sval)); }
    break;

  case 32:
#line 318 "ibnl_parser.yy"
    {
      ibnlMakeNodeToNodeConn((yyvsp[-8].ival), (yyvsp[-6].sval), (yyvsp[-4].sval), (yyvsp[-1].sval), (yyvsp[0].ival));
    }
    break;

  case 33:
#line 321 "ibnl_parser.yy"
    {
      ibnlMakeNodeToNodeConn((yyvsp[-6].ival), (yyvsp[-4].sval), "2.5", (yyvsp[-1].sval), (yyvsp[0].ival));
    }
    break;

  case 34:
#line 324 "ibnl_parser.yy"
    {
      ibnlMakeNodeToNodeConn((yyvsp[-6].ival), "4x", (yyvsp[-4].sval), (yyvsp[-1].sval), (yyvsp[0].ival));
    }
    break;

  case 35:
#line 327 "ibnl_parser.yy"
    {
      ibnlMakeNodeToNodeConn((yyvsp[-4].ival), "4x", "2.5", (yyvsp[-1].sval), (yyvsp[0].ival));
    }
    break;

  case 36:
#line 333 "ibnl_parser.yy"
    {
      ibnlMakeNodeToPortConn((yyvsp[-7].ival), (yyvsp[-5].sval), (yyvsp[-3].sval), (yyvsp[0].sval));
    }
    break;

  case 37:
#line 336 "ibnl_parser.yy"
    {
      ibnlMakeNodeToPortConn((yyvsp[-5].ival), (yyvsp[-3].sval), "2.5", (yyvsp[0].sval));
    }
    break;

  case 38:
#line 339 "ibnl_parser.yy"
    {
      ibnlMakeNodeToPortConn((yyvsp[-5].ival), "4x", (yyvsp[-3].sval), (yyvsp[0].sval));
    }
    break;

  case 39:
#line 342 "ibnl_parser.yy"
    {
      ibnlMakeNodeToPortConn((yyvsp[-3].ival), "4x", "2.5", (yyvsp[0].sval));
    }
    break;

  case 42:
#line 353 "ibnl_parser.yy"
    { ibnlMakeSubsystem((yyvsp[-1].sval),(yyvsp[0].sval)); }
    break;

  case 45:
#line 361 "ibnl_parser.yy"
    { ibnlRecordModification((yyvsp[-2].sval),(yyvsp[0].sval)); }
    break;

  case 50:
#line 374 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToSubsystemConn((yyvsp[-8].sval), (yyvsp[-6].sval), (yyvsp[-4].sval), (yyvsp[-1].sval), (yyvsp[0].sval));
    }
    break;

  case 51:
#line 377 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToSubsystemConn((yyvsp[-6].sval), (yyvsp[-4].sval), "2.5", (yyvsp[-1].sval), (yyvsp[0].sval));
    }
    break;

  case 52:
#line 380 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToSubsystemConn((yyvsp[-6].sval), "4x", (yyvsp[-4].sval), (yyvsp[-1].sval), (yyvsp[0].sval));
    }
    break;

  case 53:
#line 383 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToSubsystemConn((yyvsp[-4].sval), "4x", "2.5", (yyvsp[-1].sval), (yyvsp[0].sval));
    }
    break;

  case 54:
#line 389 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToPortConn((yyvsp[-7].sval), (yyvsp[-5].sval), (yyvsp[-3].sval), (yyvsp[0].sval));
    }
    break;

  case 55:
#line 392 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToPortConn((yyvsp[-5].sval), (yyvsp[-3].sval), "2.5", (yyvsp[0].sval));
    }
    break;

  case 56:
#line 395 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToPortConn((yyvsp[-5].sval), "4x", (yyvsp[-3].sval), (yyvsp[0].sval));
    }
    break;

  case 57:
#line 398 "ibnl_parser.yy"
    {
      ibnlMakeSubsystemToPortConn((yyvsp[-3].sval), "4x", "2.5", (yyvsp[0].sval));
    }
    break;


    }

/* Line 1037 of yacc.c.  */
#line 1478 "ibnl_parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {

		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct ("Error: popping",
                             yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct ("Error: discarding lookahead",
              yytoken, &yylval);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 403 "ibnl_parser.yy"


int yyerror(char *msg)
{
  printf("-E-ibnlParse:%s at line:%ld\n", msg, lineNum);
  ibnlErr = 1;
  return 1;
}

/* parse apollo route dump file */
int ibnlParseSysDefs (IBSystemsCollection *p_sysColl, const char *fileName) {
  extern FILE * yyin;

  gp_sysColl = p_sysColl;
  gp_fileName = fileName;

  /* open the file */
  yyin = fopen(fileName,"r");
  if (!yyin) {
	 printf("-E- Fail to Open File:%s\n", fileName);
	 return(1);
  }
  if (FabricUtilsVerboseLevel & FABU_LOG_VERBOSE)
     printf("-I- Parsing:%s\n", fileName);

  ibnlErr = 0;
  lineNum = 1;
  /* parse it */
  yyparse();

  fclose(yyin);
  return(ibnlErr);
}



