<?php
// File           jsrs/systable_filter_request.php / ibWebAdmin
// Purpose        deliver the html for the system table filter selectlists
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <03/05/29 22:34:04 lb>
//
// $Id: systable_filter_request.php,v 1.5 2004/03/28 11:29:00 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');

session_start();
localize_session_vars();

require('../lang/' . (isset($s_cust) ? $s_cust['language'] : LANGUAGE) . '.inc.php');
require('../inc/functions.inc.php');
require('../inc/get_tables.inc.php');
require('../inc/panel_elements.inc.php');
require('../inc/system_table.inc.php');
require('./jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

$dbhandle = db_connect();

jsrsDispatch('filter_fields, filter_values');


// build the answer for the jsrs requests
function filter_fields($table){

    $html = systable_field_select($table);
    $s_systable['table']  = $table;
    $s_systable['ffield'] = '';
    $s_systable['fvalue'] = '';

    globalize_session_vars();

    return jsrsArrayToString(array($html), $delim='~');
}

function filter_values($table, $field) {

    $html = systable_value_select($table, $field);
    $s_systable['ffield'] = $field;
    $s_systable['fvalue'] = '';

    globalize_session_vars();

    return jsrsArrayToString(array($html), $delim='~');
}

?>
