<?php
// File           watchtable.php / ibWebAdmin
// Purpose        handling for the navigation elements on the watchtable-panel
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <01/02/03 19:58:28 lb>
//
// $Id: watchtable.php,v 1.15 2004/03/28 11:34:13 lbrueckner Exp $


include('inc/script_start.inc.php');

if ($s_connected) {
    $dbhandle = db_connect()
         or ib_error();
}


// handle the paging navigation
if (isset($HTTP_GET_VARS['go'])) {
    switch ($HTTP_GET_VARS['go']) {
        case 'start' :
            $s_watch_start = 1;
            break;
        case 'prev' :
            $s_watch_start -= $s_watch_rows;
            break;
        case 'next' :
            $s_watch_start += $s_watch_rows;
            break;
        default :
            $s_watch_start = $HTTP_GET_VARS['go'];
    }
}

// ordering by the column headlines
elseif (isset($HTTP_GET_VARS['order'])) {
    if ($s_watch_sort == $HTTP_GET_VARS['order']) {
        $s_watch_direction = ($s_watch_direction == 'ASC') ? 'DESC' : 'ASC';
    }
    else {
        $s_watch_sort = $HTTP_GET_VARS['order'];
        $s_watch_direction = 'ASC';
    }
    $s_watch_start = 1;
}

// editing of a dataset is requested
elseif (isset($HTTP_GET_VARS['edit'])) {
    $s_edit_idx = ($s_edit_idx > 0) ? get_max_key($s_edit_where) + 1 : 1;
    $target_panels = get_panel_array($HTTP_SERVER_VARS['HTTP_REFERER']);
    $pname = 'dt_edit'.$s_edit_idx;
    $instance = ($s_edit_idx > 1) ? "($s_edit_idx) " : '';
    $ptitle = sprintf($dt_strings['EditFrom'], $instance, $s_watch_table);
    ${$target_panels}[] = array($pname, $ptitle, 'open');
    $pos = get_panel_index($$target_panels, $pname);
    $$target_panels = array_moveto_top($$target_panels, $pos);
    $where = get_request_data('edit', 'GET');
    $s_edit_where[$s_edit_idx] = array('where' => $where,
                                       'table' => $s_watch_table);
}

// deleting of a dataset is requested
elseif (isset($HTTP_GET_VARS['del'])) {

    $where = get_request_data('del', 'GET');

    $sql = 'DELETE FROM '.$s_watch_table.' '.$where;

    if ($s_cust['askdel'] == TRUE) {
        $s_delete_idx = ($s_delete_idx > 0) ? get_max_key($s_confirmations['row']) + 1 : 1;
        $target_panels = get_panel_array($HTTP_SERVER_VARS['HTTP_REFERER']);
        $pname = 'dt_delete'.$s_delete_idx;
        $ptitle = 'Delete';
        $ptitle .= ($s_delete_idx > 1) ? " ($s_delete_idx) " : ' ';
        $ptitle .= 'from table '.$s_watch_table;
        ${$target_panels}[] = array($pname, $ptitle, 'open');
        $pos = get_panel_index($$target_panels, $pname);
        $$target_panels = array_moveto_top($$target_panels, $pos);

        $s_confirmations['row'][$s_delete_idx] = 
             array('msg' => sprintf($MESSAGES['CONFIRM_ROW_DELETE'], $s_watch_table, $where),
                   'sql' => $sql);
    }

    else {  
        ibase_query($dbhandle, $sql)
            or $ib_error = ibase_errmsg();

        // cleanup the watchtable output buffer
        $s_watch_buffer = '';
    }
}


if (WATCHTABLE_METHOD == WT_STORED_PROCEDURE
||  (WATCHTABLE_METHOD == WT_BEST_GUESS  &&  guess_watchtable_method(SERVER_FAMILY, SERVER_VERSION) == WT_STORED_PROCEDURE)) {
    include('inc/stored_procedures.inc.php');

    sp_limit_create($s_watch_table,
                    $s_watch_columns,
                    $s_watch_sort,
                    $s_watch_direction,
                    $s_watch_condition,
                    $s_watch_start,
                    $s_watch_rows);
}


// cleanup the watchtable output buffer
if (isset($HTTP_GET_VARS['go'])  ||  isset($HTTP_GET_VARS['order'])) {
    $s_watch_buffer = '';
}


globalize_session_vars();

if (!empty($dbhandle)) {
    ibase_close($dbhandle);
}

header ('Location: '.url_session($HTTP_SERVER_VARS['HTTP_REFERER']));
exit;

?>
