/* commandline.c
 * - Commandline parsing *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#ifdef _WIN32
#include <win32config.h>
#else
#include <config.h>
#endif
#endif

#include "definitions.h"
#include <stdio.h>
#include "definitions.h"

#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>

#ifndef _WIN32
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include "avl.h"
#include "threads.h"
#include "icetypes.h"
#include "icecast.h"
#include "utility.h"
#include "ice_string.h"
#include "log.h"
#include "commands.h"
#include "memory.h"

#include "commandline.h"

extern server_info_t info;

void usage()
{
	printf("i c e c a s t - Version %s\n", VERSION);
	printf(" ` ` ` ` ` `\n");
	printf("Usage:\n");
	printf("icecast [-P <port>] [-p password] [-l <file>] [-d <directory>] [-c <configfile>] [-b]\n");
	printf("\n");
	printf("\tOptions explained (compiled default in parenthesis):\n");
	printf("\t-c: Configuration file to use (%s)\n", DEFAULT_CONFIG_FILE);
	printf("\t-P: port on which the server will listen for client connections (%d)\n", DEFAULT_PORT);
	printf("\t-p: password to validate encoders (%s)\n", DEFAULT_ENCODER_PASSWORD);
	printf("\t-l: file for logging (%s)\n", DEFAULT_LOGFILE);
	printf("\t-b: Force icecast server into the background\n");
	printf("\t-d: Use this directory as the location of the config files\n");
	printf("\n\n");
}

void 
parse_directory_args_only (int argc, char **argv)
{
	int arg;
	char *s;
	
	arg = 1;
	
	if (!argv || !argv[0]) {
		write_log (LOG_DEFAULT, "WARNING: parse_directory_args_only() called with invalid argv");
		return;
	}

	xa_debug (1, "DEBUG: Parsing command line directory arguments");

	while (arg < argc) {
		s = argv[arg];
		
		if (s[0] == '-') {
			if ((s[1] == 'd') && arg >= (argc - 1))
			{
				fprintf (stderr, "Option %c requires an argument!\n", s[1]);
				exit (1);
			}
			switch (s[1]) {
				case 'd':
					arg++;
					if (info.etcdir)
					  nfree (info.etcdir);
					info.etcdir = nstrdup(argv[arg]);
					break;
			}
		}
		arg++;
	}
}

void
parse_args(int argc, char **argv)
{
        int arg;
        char *s;

        arg = 1;

	xa_debug (1, "DEBUG: Parsing command line arguments");

        while (arg < argc) {
                s = argv[arg];

                if (s[0] == '-') {
                  if (s[1] != 'b' && s[1] != 'V' && s[1] != 'h' && arg >= (argc - 1))
		  {
			  fprintf (stderr, "Option %c requires an argument!\n", s[1]);
			  exit (1);
		  }
                  switch (s[1]) {
			  case 'c':
				  arg++;
				  if (info.configfile)
					nfree (info.configfile);
				  info.configfile = nstrdup (argv[arg]);
				  parse_config_file (info.configfile);
				  break;
			  case 'P':
				  arg++;
				  info.port[0] = atoi(argv[arg]);
				  break;
			  case 'p':
				  arg++;
				  if (info.encoder_pass)
					nfree (info.encoder_pass);
				  info.encoder_pass = nstrdup (argv[arg]);
				  break;
			  case 'b':
				  info.console_mode = CONSOLE_BACKGROUND;
				  break;
			  case 'l':
				  arg++;
				  if (info.logfilename)
					nfree (info.logfilename);
				  info.logfilename = nstrdup (argv[arg]);
				  break;
			  case 'd':
				  arg++;
				  break;
			  case 'V':
				  info.logfiledebuglevel = 8;
				  info.consoledebuglevel = 8;
				  break;
			  default:
				  usage();
				  exit(1);
		  }
                } else {
                        usage();
                        exit(1);
                }
                arg++;
        }
}
