/* You may find the license in the LICENSE file */

// Appends/Inserts a renaming mask tag into the current mask text
function appendTag(event) {
	var text = $('renaming');
	var value = event.target.getAttribute("value");
	var s = text.inputField.selectionStart;
	text.value = text.value.substring(0, s) + value + text.value.substring(text.inputField.selectionEnd, text.value.length);
	text.inputField.setSelectionRange(s + event.target.getAttribute("value").length, s + value);
}

// Handles Drag'n'Drop
var listObserver = {
	onDragStart: function (evt, transferData, action){
		// Add the mask text to the d'n'd data collection
		transferData.data = new TransferData();
		transferData.data.addDataForFlavour("text/unicode", evt.target.getAttribute("value"));
	}
};