/***************************************************************************
                          ribplugin.h  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RIBPLUGIN_H
#define RIBPLUGIN_H

#include "cribdialog.h"
#include <iostream.h>
#include <fstream.h>
#include <qvariant.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qcheckbox.h>

#include <Plugins/dialogplugin.h>
#include <Entities/entitylib.h>

class DialogPlugin;

class RIBPlugin : public DialogPlugin, public CRIBDialog
{ 

public:
    RIBPlugin();
    ~RIBPlugin();

    void startPlugin();
    void stopPlugin();

    void saveMesh(Mesh *);
    void saveSurface(NurbsSurface *);
    void saveHeader();
    void saveTexturesAsTiffs();

    void getOptions();

public slots:

    void slotHelp();
    void slotRender();
    void slotSave();
    void slotSavePathBrowse();
    void slotRendRibBrowse();
    void slotShaderPathBrowse();

 protected:
    ofstream out;

    int height;
    int width;
    bool toFile;
    bool toScreen;
    QString strRendribPath;
    QString strShaderPath;
    QString strSaveToPath;
    QString strName;
    

};

#endif // RIBDLG_H
