-- Emacs-like keyboard configuration for Ion, version 3.
-- Written by Matthieu MOY (Matthieu.Moy@imag.fr) on February 15, 2005.
-- No copyright.

-- Copy this file in your ~/.ion3/ directory
-- Add the line
-- dopath("emacs-bindings")
-- At the *end* of your ~/.ion3/cfg_ion.lua file, or in ~/.ion3/cfg_user.lua

-- Comments/Feedback welcome.


-- ChangeLog:
--   David Hansen <david.hansen@physik.fu-berlin.de> (all public domain)
--
-- * DEFAULT_MOD -> MOD1
-- * WEdln: M-f, M-b, M-backspace, M-d, M-p, M-n, M-right, M-left
-- * WEdln: C-g clear mark or abort if the mark is not set
-- * WEdln: C-k copy to clipboard
-- * WMPlex: removed C-! C-:, C-x b (they are also in WScreen)
-- * WMPlex: C-q, C-x C-k, C-u C-x C-k
-- * WScreen: C-x C-b, C-x w, C-x C-w
-- * WIonWS: C-x 2, C-x 3 a bit more emacs like
-- * WIonWS: fixed C-x o
-- * WIonWS: removed C-x C-x *

Emacs = {};


-- Download it from http://modeemi.cs.tut.fi/~tuomov/repos/ion-scripts-3/scripts/collapse.lua
dopath("collapse")

--
-- WIonWS_X
--

function WIonWS.other_client(ws, sub)
    if ws:current() == ws:goto_dir('right') then
        ws:goto_dir('bottom')
    end
end

Emacs.WIonWS_X = {
    kpress ("AnyModifier+1", "collapse.collapse(_)"),
    kpress ("AnyModifier+2", "WIonWS.split_at(_, _sub, 'top', true)"),
    kpress ("AnyModifier+3", "WIonWS.split_at(_, _sub, 'left', true)"),
    kpress ("AnyModifier+o", "WIonWS.other_client(_, _sub)"),
}

Emacs.WIonWS = {
    kpress(MOD1.."Tab", nil),
    submap(MOD1.."x", Emacs.WIonWS_X),
}

defbindings("WIonWS", Emacs.WIonWS)

--
-- WMPlex
--
-- odds:
--   * C-TAB, C-S-TAB, C-SPACE, C-C-SPACE, C-u C-x k are not emacs binding
--   * C-:, C-! should maybe M-, M-!: (we would need to set MOD2, probably
--     not a good idea)
--   * C-: is actually C-;
--

-- in case of nested workspaces, switch next/previous at the top
-- level.
function Emacs.switch_next(frame)
   if obj_is(frame:parent(),"WFrame") then
      Emacs.switch_next(frame:parent())
   else
      frame:switch_next()
   end
end

function Emacs.switch_prev(frame)
   if obj_is(frame:parent(),"WFrame") then
      Emacs.switch_prev(frame:parent())
   else
      frame:switch_prev()
   end
end

Emacs.WMPlex_UX = {
    kpress("k", "WClientWin.kill(_sub)", "_sub:WClientWin"),
}

Emacs.WMPlex_U = {
    submap(MOD1.."x", Emacs.WMPlex_UX),
}

Emacs.WMPlex_X = {
    kpress("b", "mod_query.query_attachclient(_)"),    
    kpress("k", "WRegion.rqclose_propagate(_, _sub)"),
}

Emacs.WMPlex = {
    submap(MOD1.."x", Emacs.WMPlex_X),
    submap(MOD1.."u", Emacs.WMPlex_U),
    kpress(MOD1.."q", "WClientWin.quote_next(_sub)", "_sub:WClientWin"),
    kpress(MOD1.."Tab", "Emacs.switch_next(_)"),
    kpress(MOD1.."Shift+Tab", "Emacs.switch_prev(_)"),
    kpress(MOD1.."space", "WRegion.set_tagged(_sub, 'toggle')"),
    kpress(MOD1.."Control+space", "WFrame.attach_tagged(_)"),
}

defbindings("WMPlex", Emacs.WMPlex)

--
-- WScreen
--
-- odds:
--   * C-x w, C-x C-w are not emacs bindings
--   * C-x b should really attach *and* focus the client
--

Emacs.WScreen_X = {
    kpress("b", "mod_query.query_gotoclient(_)"),
    kpress(MOD1.."b", "mod_menu.menu(_, _sub, 'windowlist')"),
    kpress("w", "mod_query.query_workspace(_)"),
    kpress(MOD1.."w", "mod_menu.menu(_, _sub, 'workspacelist')"),
}

Emacs.WScreen = {
    kpress(MOD1.."colon", "mod_query.query_lua(_)"),
    kpress(MOD1.."exclam", "mod_query.query_exec(_)"),
    submap(MOD1.."x", Emacs.WScreen_X),
}

defbindings("WScreen", Emacs.WScreen);

--
-- WEdln
--
-- odds:
--   M-d, M-backspace don't copy to the clipboard
--   M-p, M-n do eshell like history, C-p, C-n model-line like history
--

function WEdln:cut_to_eol ()
    self:set_mark()
    self:eol()
    self:cut()
end

function WEdln:clear_mark_or_abort ()
    if -1 ~= self:mark() then
        self:clear_mark()
    else
        self:cancel()
    end
end

Emacs.WEdln = {
    kpress("Mod1+f", "WEdln.skip_word(_)"),
    kpress("Mod1+b", "WEdln.bskip_word(_)"),
    kpress("Mod1+Right", "WEdln.skip_word(_)"),
    kpress("Mod1+Left", "WEdln.bskip_word(_)"),
    kpress("Mod1+d", "WEdln.kill_word(_)"),
    kpress("Mod1+BackSpace", "WEdln.bkill_word(_)"),
    kpress("Control+K", "WEdln.cut_to_eol(_)"),
    kpress("Control+W", "WEdln.cut(_)"),
    kpress("Control+Y", "WEdln.paste(_)"),
    kpress("Control+space", "WEdln.set_mark(_)"),
    kpress("Control+G", "WEdln.clear_mark_or_abort(_)"),
    kpress("Mod1+p", "WEdln.history_prev(_, true)"),
    kpress("Mod1+n", "WEdln.history_next(_, true)"),
}

defbindings("WEdln", Emacs.WEdln)
