/***

packet.h - external declarations for packet.c
           
Written by Gerard Paul Java

***/

/*
 * Number of bytes from captured packet to move into an aligned buffer.
 * 96 bytes should be enough for the IP header, TCP/UDP/ICMP/whatever header
 * with reasonable numbers of options.
 */
 
#define SNAPSHOT_LEN 96
#define MAX_PACKET_SIZE 8192
#define ALIGNED_BUF_LEN 120

#define min(a, b) ((a > b) ? b : a)

void open_socket(int *fd);
unsigned short getlinktype(unsigned short family, char *ifname,
                           int isdn_fd, struct isdntab *isdntable);
void adjustpacket(char *tpacket, unsigned short family,
                  char **packet, char *aligned_buf, int *readlen);
void getpacket(int fd, char *buf, struct sockaddr_ll *fromaddr,
	       int *ch, int *br, char *ifname, WINDOW * win);
