<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
include("../lib/Net_SNMP.php");
require_once 'include/i18n.php';

AuthCheck("tech");

commonHeader(_("Networking") . " - " . _("Add Port"));


__("Fill out this simple form to add a port to the device."); ?>
<hr noshade>

<?php
if ($cfg_snmp == 1) {
        $data=SNMPwalkComputer($_GET['device'], 'interfaces.ifTable.ifEntry.ifIndex');
        PRINT "<form method=get>";
        PRINT "<SELECT NAME=\"ifIndex\" SIZE=1>\n";

        foreach ($data as $listitem)
	{
		$realdata = explode(' ', $listitem);
		$name = SNMPgetComputerObject($_REQUEST['device'], 'interfaces.ifTable.ifEntry.ifDescr.'.$realdata[1]);
		$realname=explode(' ', $name);
		PRINT "<OPTION VALUE=\"$realdata[1]\"> $realname[1] </OPTION>\n";
        }
        PRINT "</SELECT>";
        PRINT "<input type=hidden name=device value=".$_REQUEST['device'].">\n";
        PRINT "<input type=hidden name=device_type value=".$_REQUEST['device_type']. ">\n";
        PRINT "<input type=submit value=\""._("Get")."\">\n";
        PRINT "</FORM>\n";
        $name="";
}

if (isset($_REQUEST['ifIndex']))
{
	$snmpdesc = SNMPgetComputerObject($_REQUEST['device'],
			'interfaces.ifTable.ifEntry.ifDescr.'.$_REQUEST['ifIndex']);
        list( ,$name) = explode(' ', $snmpdesc);

        $ifaddr=SNMPgetfirstIpFromIfIndex($_REQUEST['device'],
			$_REQUEST['ifIndex']);

	$snmpmac = SNMPgetComputerObject($_REQUEST['device'],
			'interfaces.ifTable.ifEntry.ifPhysAddress.'.$_REQUEST['ifIndex']);
        list( ,$ifmac)=explode(' ', $snmpmac);

        $logical_number=$_GET['ifIndex'];
}
?>

<form method=get action="<?php echo Config::AbsLoc('users/networking-port-add.php') ?>">
<table border=1>

<?php
if (!@$logical_number)
{
	$logical_number = '';
}
PRINT "<tr><td>"._("Logical Number:")."</td><td><input type=text size=5 name=logical_number value=$logical_number></td></tr>";
if (!@$name)
{
	$name = '';
}
		PRINT "<tr><td>"._("Name")."</td><td><input type=text size=20 value=\"$name\" name=name></td></tr>";
		PRINT "<tr><td>"._("Interface")."</td><td>";
if (!@$iface)
{
	$iface = '';
}
		Dropdown_value("dropdown_iface","iface", $iface);
		
		
		PRINT "</td></tr>";
if (!@$ifaddr)
{
	$ifaddr = '';
}
if (!@$ifmac)
{
	$ifmac = '';
}

PRINT "<tr><td>"._("IP Address")."</td>
	<td><input type=text size=20 name=ifaddr value=\"$ifaddr\">
	</td></tr>";

PRINT "<tr><td>"._("MAC/Network Address")."</td>
	<td><input type=text size=25 name=ifmac value=\"$ifmac\">
	</td></tr>";

PRINT "<tr><td><input type=hidden name=device value=$device>
	<input type=hidden name=device_type value=$device_type>
	<input type=submit value=\""._("Add")."\"></td>
	<td><input type=reset value=\""._("Clear")."\"></td></tr></form>
	</table>";

commonFooter();
