<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
include("../include/reports.inc.php");
require_once 'include/i18n.php';

AuthCheck("normal");
$count = count($report_list);
commonHeader(_("Reports"));
__("Welcome to IRM Reports.  This feature of IRM allows you to gain information
on your organization as a whole.  This is a modular section of IRM, allowing easy integration of third-party report modules.  For information regarding writting your own modules, take a look at docs/REPORTS in your IRM installation.");
?>
<hr noshade>
<?php __("Select a report module below:") ?>
<br>

<?php
foreach ($report_list as $data)
{
	$name = $data['name'];
	$file = $data['file'];
	PRINT '<a href="'.Config::AbsLoc("users/$file")."\">$name</a><br>";
}

commonFooter();
