#include <stdio.h>

#include "autosocket.h"

#include "libcompat.h"

/* This is a simplified version of getnameinfo.  It does not support address
   families other than PF_INET. */

int getnameinfo(const struct sockaddr *sa, socklen_t salen, char *host,
		size_t hostlen, char *serv, size_t servlen, int flags)
{
    const struct sockaddr_in *const sa_in = (struct sockaddr_in *)sa;

    if(flags & ~(NI_NUMERICHOST | NI_NUMERICSERV | NI_NAMEREQD))
	return EAI_BADFLAGS;
    if(sa->sa_family != AF_INET)
	return EAI_FAMILY;
    if(!((host && hostlen) || (serv && servlen)))
	return EAI_NONAME;

    if(host && hostlen) {
	if(flags & NI_NUMERICHOST) {
	    if(flags & NI_NAMEREQD)
		return EAI_BADFLAGS;
	    strncpy(host, inet_ntoa(sa_in->sin_addr), hostlen);
	    host[hostlen - 1] = '\0';
	} else {
	    return EAI_BADFLAGS;
	}
    }

    if(serv && servlen) {
	if(flags & NI_NUMERICSERV) {
	    int ret = snprintf(serv, servlen, "%d", ntohs(sa_in->sin_port));

	    if(ret < 0)
		return EAI_SYSTEM;
	} else {
	    return EAI_BADFLAGS;
	}
    }

    return 0;
}
