dnl TODO: if winsock 1 is not found, but winsock 2 is available autodetection
dnl will fail because CHECK_WINSOCK1 leaves -lwsock32 in $LIBS when it fails

dnl CHECK_WINSOCK([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_WINSOCK],[dnl
AC_MSG_CHECKING([for winsock 1])
LIBS="$LIBS -lwsock32"
AC_LINK_IFELSE([AX_LANG_CALL_ARGS([[#include <winsock.h>]],dnl
	[SOCKET], [socket], [int, int, int])],dnl
	[AC_MSG_RESULT([yes]); $1], [AC_MSG_RESULT([no]); $2])dnl
])dnl

dnl CHECK_WINSOCK2([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_WINSOCK2],[dnl
AC_MSG_CHECKING([for winsock 2])
LIBS="$LIBS -lws2_32"
AC_LINK_IFELSE([AX_LANG_CALL_ARGS([[#include <winsock2.h>]],dnl
	[SOCKET], [socket], [int, int, int])],dnl
	[AC_MSG_RESULT([yes]); $1], [AC_MSG_RESULT([no]); $2])dnl
])dnl

dnl CHECK_SOCKETS
AC_DEFUN([CHECK_SOCKETS],[dnl
AC_ARG_WITH([sockets], AS_HELP_STRING([--with-sockets],dnl
	[choose which socket library to use (default = auto)]), ,dnl
	[with_sockets=auto])
case "$with_sockets" in
"posix" )
  AC_SEARCH_LIBS([socket], [socket],dnl
	AC_MSG_ERROR([cannot find POSIX socket library])) ;;
"winsock" )
  CHECK_WINSOCK(, AC_MSG_ERROR([cannot find Winsock 1])) ;;
"winsock2" )
  CHECK_WINSOCK2(, AC_MSG_ERROR([cannot find Winsock 2])) ;;
"auto" )
  AC_SEARCH_LIBS([socket], [socket], [with_sockets=posix],dnl
	CHECK_WINSOCK([with_sockets=winsock],dnl
	CHECK_WINSOCK2([with_sockets=winsock2],dnl
	AC_MSG_ERROR([cannot find a socket library])))) ;;
* )
  AC_MSG_ERROR([unknown option --with-sockets=$with_sockets]) ;;
esac
if test "$with_sockets" = "winsock"; then
  AC_DEFINE([USE_WINSOCK], [1], [Define to 1 to enable use of Winsock 1.1 or 2 to enable use of Winsock 2.2])
elif test "$with_sockets" = "winsock2"; then
  AC_DEFINE([USE_WINSOCK], [2])
fi
])dnl

dnl CHECK_SOCKET_FUNC(RETTYPE, FUNCTION, ARGS, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_SOCKET_FUNC],[dnl
AX_CHECK_FUNC_ARGS(["$srcdir/src/autosocket.h"], [$1], [$2], [$3],dnl
	AC_DEFINE(AS_TR_CPP(HAVE_$2), [1],dnl
	[Define to 1 if you have the ']$2[' function.]) [$4], [$5])dnl
])dnl

dnl REPLACE_SOCKET_FUNC(RETTYPE, FUNCTION, ARGS)
AC_DEFUN([REPLACE_SOCKET_FUNC],[dnl
CHECK_SOCKET_FUNC([$1], [$2], [$3], [], [AC_LIBOBJ([$2])])dnl
])dnl
