/*
 * Copyright (C) 2003, 2004 Robert Lougher <rob@lougher.demon.co.uk>.
 *
 * This file is part of JamVM.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define COMPARE_AND_SWAP(addr, old_val, new_val) \
({                                               \
    int result, read_val;                        \
    __asm__ __volatile__ ("                      \
                mvn %1, #1;                      \
        1:      swp %1, %1, [%2];                \
                cmn %1, #2;                      \
                beq 1b;                          \
                cmp %3, %1;                      \
                strne %1, [%2];                  \
                movne %0, #0;                    \
                streq %4, [%2];                  \
                moveq %0, #1;"                   \
    : "=&r" (result), "=&r" (read_val)           \
    : "r" (addr), "r" (old_val), "r" (new_val)   \
    : "cc", "memory");                           \
    result;                                      \
})

#define ATOMIC_READ(addr)                        \
({                                               \
    int read_val;                                \
    __asm__ __volatile__ ("                      \
        1:      ldr %0, [%1];                    \
                cmn %0, #2;                      \
                beq 1b;"                         \
    : "=&r" (read_val) : "r" (addr) : "cc");     \
    read_val;                                    \
})

#define ATOMIC_WRITE(addr, new_val)              \
do {                                             \
    int read_val;                                \
    __asm__ __volatile__ ("                      \
                mvn %0, #1;                      \
        1:      swp %0, %0, [%1];                \
                cmn %0, #2;                      \
                beq 1b;                          \
                str %2, [%1];"                   \
    : "=&r" (read_val)                           \
    : "r" (addr), "r" (new_val)                  \
    : "cc", "memory");                           \
} while(0)
