#!/bin/sh -e

# $2 = version
# $3 = file
PACKAGE=$(dpkg-parsechangelog -S Source)
VERSION=$2
DIR=${PACKAGE}-${VERSION}
TAR=../${PACKAGE}_${VERSION}.orig.tar.xz

# clean up the upstream tarball
mkdir $DIR
tar -xf $3 --strip-components=2 -C $DIR
XZ_OPT=--best tar cvJf $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR
