/** GtkTerminalExample .java
 */ 
package vte;

import org.gnu.gnomevte.Terminal;
import org.gnu.gtk.AttachOptions;
import org.gnu.gtk.Button;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.GtkStockItem;
import org.gnu.gtk.Notebook;
import org.gnu.gtk.ReliefStyle;
import org.gnu.gtk.Table;
import org.gnu.gtk.ToolBar;
import org.gnu.gtk.Widget;
import org.gnu.gtk.Window;
import org.gnu.gtk.WindowType;
import org.gnu.gtk.event.ButtonEvent;
import org.gnu.gtk.event.ButtonListener;
import org.gnu.gtk.event.NotebookEvent;
import org.gnu.gtk.event.NotebookListener;

public class GtkTerminalExample extends Window{
	private ToolBar toolbar;
	private Terminal term;
	private Table table;
	private Notebook notebook;
	private int pageCount=0;
	
	public GtkTerminalExample (String appTitle){
		super(WindowType.TOPLEVEL);
		super.setTitle(appTitle);
		//resize(800,600);
		table = new Table(2, 1, false);
		notebook = new Notebook();
		initGUI();
			
	}

	private void initGUI(){
		notebook.addListener(new NotebookListener(){
			public void notebookEvent(NotebookEvent evt){
				handleNotebookEvent(evt);
			}
		});
			
		toolbar = createMyToolbar();
		//toolbar.setResizeMode(ResizeMode.PARENT);
		
		table.attach(toolbar, 0, 1, 0, 1,AttachOptions.FILL, AttachOptions.SHRINK, 0, 0);
		table.attach(notebook, 0, 1, 1, 2,AttachOptions.FILL, AttachOptions.FILL, 0, 0);
		
		term = Terminal.terminalAndShell();
		notebook.appendPage(term, null);
		pageCount++;
		
		add(table);
		showAll();
		
	}
		


	public ToolBar createMyToolbar (){
		toolbar = new ToolBar();
		
		Button bquit = new Button(GtkStockItem.QUIT);
		bquit.setRelief(ReliefStyle.NONE);
		toolbar.appendWidget(bquit,"","");
		
		Button bnew = new Button(GtkStockItem.NEW);
		bnew.setRelief(ReliefStyle.NONE);
		bnew.addListener(new ButtonListener(){
			public void buttonEvent(ButtonEvent evt){
				handleButtonEvent(evt);
			}
		});
		toolbar.appendWidget(bnew,"","");
		
		Button bclose = new Button(GtkStockItem.CLOSE);
		bclose.setRelief(ReliefStyle.NONE);
		bclose.addListener(new ButtonListener(){
			public void buttonEvent(ButtonEvent evt){
				closePressed(evt);
			}
		});
		toolbar.appendWidget(bclose,"","");
		
		Button bgo_back = new Button(GtkStockItem.GO_BACK);
		bgo_back.setRelief(ReliefStyle.NONE);
		bgo_back.addListener(new ButtonListener(){
			public void buttonEvent (ButtonEvent evt){
				handlePrev(evt);
			}
		});
		toolbar.appendWidget(bgo_back,"","");
		
		Button bgo_forward = new Button(GtkStockItem.GO_FORWARD);
		bgo_forward.setRelief(ReliefStyle.NONE);
		bgo_forward.addListener(new ButtonListener(){
			public void buttonEvent (ButtonEvent evt){
				handleNext(evt);
			}
		});
		toolbar.appendWidget(bgo_forward,"","");
		
		return toolbar;
	}

	public static void main(String args[]){
		Gtk.init(args);
		GtkTerminalExample te = new GtkTerminalExample ("Terminal Example"); 
		Gtk.main();
	}

	public void handleButtonEvent(ButtonEvent evt){
		if (evt.isOfType(ButtonEvent.Type.CLICK)){
			Terminal t = Terminal.terminalAndShell();
			t.show();
			notebook.appendPage(t, null);
			pageCount++;
			int num = notebook.pageNum(t);
			notebook.setCurrentPage(num);
			t.grabFocus();
		}
	}

	public void handleNotebookEvent(NotebookEvent evt){
		
	}


	public void closePressed(ButtonEvent evt){
		if(pageCount==1)
			return;
		if (evt.isOfType(ButtonEvent.Type.CLICK)){
			int current = notebook.getCurrentPage();
			System.out.println("Page " + current + "colsed.");
			notebook.removePage(current);
			pageCount--;
			current = notebook.getCurrentPage();
			Widget w = notebook.getPage(current);
			w.grabFocus();
		}
	}

	protected void handleNext(ButtonEvent evt){
		if (evt.isOfType(ButtonEvent.Type.CLICK)){
			notebook.nextPage();
		}
		
	}

	protected void handlePrev(ButtonEvent evt){
		if (evt.isOfType(ButtonEvent.Type.CLICK)){
			notebook.prevPage();
		}
	}		
		
}
//GtkTerminalExample .java 

