/* $Id: gtk-gui.cc,v 1.18 2002/04/06 23:20:52 richard Exp $ -*- C++ -*-
  __   _
  |_) /|  Copyright (C) 2001-2002 Richard Atterer
  | \/|  <richard@atterer.net>
   '` 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2 or
  later. See the file COPYING for details.

  Interface to GTK GUI. Sets up global variables pointing to the main
  GUI elements.

  "Glue code" between the interface as generated by glade (in
  gtk-interface.*, gtk-support.*) and jigdo's functionality.

*/

#include <fstream>
namespace std { }
using namespace std;
#include <ctype.h>

#include <gtk-gui.hh>
#include <job-download.hh>
#include <joblist.hh>
#include <string.hh>
//______________________________________________________________________

/* Not all of these are set up during create() - we rely on the vars
   being initialized to 0 in that case. */
GUI::Window GUI::window;
GUI::Filesel GUI::filesel;
GUI::Errorbox GUI::errorbox;
GUI::License GUI::license;
//______________________________________________________________________

// File selection dialogue - helper functions
namespace {
  using namespace GUI;

  GtkEntry* filesel_state = 0;

  // Private function for filesel_open below
  void on_filesel_okButton(GtkWidget*, gpointer) {
    if (filesel_state != 0) {
      // Copy over filename to the right GtkEntry
      GtkFileSelection* fileselObj = GTK_FILE_SELECTION(filesel.filesel);
      gtk_entry_set_text(filesel_state,
                         gtk_file_selection_get_filename(fileselObj));
    }
    gtk_widget_hide(filesel.filesel); // Close file selection window
  }

  /* Called to open filesel on e.g. a button click. When filesel's OK
     button is clicked, the selected filename is copied to "entry". */
  void filesel_open(GtkWidget*, gpointer entry) {
    gtk_widget_show(filesel.filesel);
    filesel_state = GTK_ENTRY(entry);
  }
}
//______________________________________________________________________

/* Initialisation of the GUI. Mostly does some post-processing of the
   glade-generated data structures, connecting button press events to
   the corresponding function etc. */
void GUI::create() {
  window.create();
  filesel.create();
  JobVector::initAfterGtk();

  /* Remove tabs from main window notebook, since the user is only
     allowed to switch between the pages using clicks on buttons/list
     entries. */
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(window.invisibleNotebook),FALSE);

  // Set background white for jigdo welcome screen
  GtkStyle* blackWhiteStyle =
    gtk_style_copy(gtk_widget_get_style(window.aboutJigdoLabel));
  GdkColormap* colMap = gdk_colormap_get_system();
  gdk_color_white(colMap, &(blackWhiteStyle->bg[GTK_STATE_NORMAL]));
  gdk_color_black(colMap, &(blackWhiteStyle->fg[GTK_STATE_NORMAL]));
  gtk_widget_set_style(window.aboutBgnd, blackWhiteStyle);
  gtk_widget_set_style(window.aboutJigdoLabel, blackWhiteStyle);
  gtk_style_unref(blackWhiteStyle);

  /* Handler to copy filename to right GtkEntry when OK is pressed
     in filesel */
  gtk_signal_connect(GTK_OBJECT(filesel.okButton), "clicked",
                     GTK_SIGNAL_FUNC(on_filesel_okButton), NULL);

  /* Open filesel window when buttons are clicked, enter result in
     appropriate GtkEntry */
  gtk_signal_connect(GTK_OBJECT(window.open_URLSel), "clicked",
                     GTK_SIGNAL_FUNC(filesel_open),
                     GTK_OBJECT(window.open_URL));
  gtk_signal_connect(GTK_OBJECT(window.open_destSel), "clicked",
                     GTK_SIGNAL_FUNC(filesel_open),
                     GTK_OBJECT(window.open_dest));

  gtk_entry_set_text(GTK_ENTRY(window.open_dest), g_get_home_dir());
# if DEBUG
  gtk_entry_set_text(GTK_ENTRY(window.open_URL),
                     "http://elessar.lan:8000/~richard/ironmaiden/image");
  //"http://elessar.lan/~richard");
# endif
}
//______________________________________________________________________

// Callback handlers

void on_toolbarExit_clicked(GtkButton*, gpointer) {
  gtk_main_quit();
}

gboolean on_window_delete_event(GtkWidget*, GdkEvent*, gpointer) {
  gtk_main_quit();
  return TRUE;
}

void setNotebookPage(GtkWidget* pageObject) {
  GUI::jobVector.setWindowOwner(0);
  GtkNotebook* n = GTK_NOTEBOOK(pageObject->parent);
  gtk_notebook_set_page(n, gtk_notebook_page_num(n, pageObject));
}

void on_openButton_clicked(GtkButton*, gpointer) {
  Job* j = new DownloadJob(gtk_entry_get_text(GTK_ENTRY(window.open_URL)),
                           gtk_entry_get_text(GTK_ENTRY(window.open_dest)));
  GUI::jobVector.append(j);
}

// Display jigdo license
void on_aboutJigdoButton_clicked(GtkButton*, gpointer) {
  if (GUI::license.license == 0) GUI::license.create();
  GtkText* text = GTK_TEXT(GUI::license.licenseText);
  if (gtk_text_get_length(text) == 0) {
    static const char* const copying = PACKAGE_DATA_DIR DIRSEPS "COPYING";
    static const char* const intro = _(
    "\n\tCopyright (C) 2001-2002 Richard Atterer <richard@atterer.net>\n"
    "\tJigsaw Download homepage: http://atterer.net/jigdo\n"
    "\n"
    "Jigsaw Download is free software; you can redistribute it and/or "
    "modify it under the terms of the GNU General Public License, version "
    "2, as published by the Free Software Foundation.\n"
    "Please note: The copyright notice below only applies to the text of "
    "the GNU General Public License; the copyright of the program is as "
    "specified above. Also note that the code is licensed under GPL "
    "version _2_ and no other version.\n\n\n\n");
    gtk_text_set_word_wrap(text, TRUE);
    gtk_text_insert(text, 0, 0, 0, intro, -1);
    static const int BUF_SIZE = 1024;
    char buf[BUF_SIZE];
    ifstream file(copying);
    while (file) {
      file.read(buf, BUF_SIZE);
      size_t n = file.gcount();
      for (size_t i = 1; i < n - 2; ++i) { // Very simple reformatting
        if (buf[i] == '\f')
          buf[i] = '\n';
        else if (buf[i] == '\n' && buf[i - 1] != '\n' && isgraph(buf[i + 1]))
          buf[i] = ' ';
      }
      gtk_text_insert(text, 0, 0, 0, buf, file.gcount());
    }
    if (!file.eof() && !file) {
      string err = subst(_("Error loading `%1': %2"),
                         copying, strerror(errno));
      gtk_text_insert(text, 0, 0, 0, err.c_str(), -1);
    }
  }
  gtk_widget_show(GUI::license.license);
  gtk_widget_grab_focus(GUI::license.licenseText);
}
