#ifndef JMPTIME_H__
#define JMPTIME_H__

#include <sys/time.h>
#include <jni.h>
#include <jvmpi.h>

/** Returns a jlong with the current time in nanoseconds.
 *  If gettimeofday is available it is used, otherwise we 
 *  use jvmpi->GetCurrentThreadCpuTime, which is not the same 
 *  thing but similar...
 * 
 */
jlong get_absolute_time (JVMPI_Interface* jvmpi);

extern jlong (*get_thread_time) (JVMPI_Interface* jvmpi);

/**
 * Final calibration of the timinig functions. Set absolute time to true if
 * absolute times are preferred against cpu times.
 */
void jmptime_init (int absolute_time, const char* vm_version,
		   const char* vm_vendor, const char* vm_name);

#endif /* JMPTIME_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
