#ifndef STRING_DUMPER_H__
#define STRING_DUMPER_H__

#include <jni.h>
#include <jvmpi.h>

/** Dump all strings into the next jmp_string_dump-<number>.txt file. */
void dump_strings ();

/** Get the next string dump file. */
FILE* get_string_dump_file ();

/** Get the name of the current dump file. */
char* get_current_dump_file ();

char* utf16_to_utf8 (char* text, size_t count, long* items_written, int* err);

/** write the utf-8 text into the file. */
int write_string (FILE* f, char* text, int count, int used);

#endif /* STRING_DUMPER_H__ */
