#include <jmp-config.h>

#include <stdio.h>
#include <string.h>

#include <ui_gtk_gtkutils.h>

void add_menu_item (GtkWidget* menu, char* text, GCallback func) {
    GtkWidget* menuitem = gtk_menu_item_new_with_label (text);
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
    gtk_signal_connect_object (GTK_OBJECT (menuitem), "activate",
			       GTK_SIGNAL_FUNC (func),
			       GTK_OBJECT (menuitem));
}

void add_menu_separator (GtkWidget* menu) {
    GtkWidget* separator = gtk_separator_menu_item_new ();
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), separator);    
}

void add_left_label_to_table (char* text, GtkWidget* table, int row, int col) {
    GtkWidget* label = gtk_label_new (text);
    gtk_table_attach (GTK_TABLE (table), label, col, col + 1, row, row + 1, 
		      GTK_FILL, 0, 0, 0);
    gtk_label_set_justify (GTK_LABEL (label),  GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
}

GtkWidget* get_table (gchar** labels, tablefunc funcs[], void* v) {
    int i = 0;
    GtkWidget* table = gtk_table_new (1, 2, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 2);

    while (labels[i] != NULL) {
	add_left_label_to_table (labels[i], table, i, 0);
	add_left_label_to_table (funcs[i](v), table, i, 1);    
	i++;
    } 
    return table;
}

void add_column (GtkWidget* tree, char* label, int pos, 
		 gpointer data, 
		 void (*cb)(GtkWidget*, gpointer), 
		 gint width,  /* set starting width in pixels */
		 int align)   /* 0 = left, 0.5 = center, 1 = right */
{
    GtkCellRenderer *renderer = gtk_cell_renderer_text_new ();
    GtkTreeViewColumn *column = 
	gtk_tree_view_column_new_with_attributes (label, renderer,
						  "text", pos, NULL);
    /* TODO this cant be the right way to set alignment can it? /robo */
    renderer->xalign = align;
    
    gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
    gtk_tree_view_column_set_min_width (column, width);
    if (cb != NULL)
	g_signal_connect (G_OBJECT (column), "clicked", G_CALLBACK (cb), data);
}

/** updates a tree with new data. 
 */
void update_tree (GtkListStore* list, int count, int max_rows, void** items, 
		  add_row_func add_row_to_list, int current_size) {
    GtkTreeIter   iter;
    int i;
    gtk_tree_model_get_iter_first (GTK_TREE_MODEL (list), &iter);
    for (i = 0; i < count && i < max_rows; i++) {
	add_row_to_list (items[i], i, &iter); 
    }
    if (i < current_size) {
	gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list), 
				       &iter, NULL, i);
	for (; i < current_size; i++) {
	    /* this updates iter to point to next valid iter.. */
	    gtk_list_store_remove (list, &iter);  
	}
    }
}

void remove_children (GtkTreeStore* treestore, GtkTreeIter* node) {
    GtkTreeIter iter, tmp;
    gboolean valid;
    if (gtk_tree_model_iter_has_child (GTK_TREE_MODEL (treestore), node)) {
	gtk_tree_model_iter_children (GTK_TREE_MODEL (treestore), &iter, node);
	valid = TRUE;
	while (valid) {
	    memcpy (&tmp, &iter, sizeof (GtkTreeIter));
	    valid = gtk_tree_model_iter_next (GTK_TREE_MODEL (treestore), &iter);
	    gtk_tree_store_remove (treestore, &tmp);
	} 
    } 
}

void expand_node (GtkTreeStore* treestore, GtkObject* list, GtkTreeIter* node) {
    GtkTreePath* path;
    path = gtk_tree_model_get_path (GTK_TREE_MODEL (treestore), node);
    gtk_tree_view_expand_row (GTK_TREE_VIEW (list), path, FALSE); 
    gtk_tree_path_free (path);			
}

/** Disable closing of window.
 */
gint ignore_delete_event (GtkWidget *widget, GdkEvent  *event, 
				 gpointer   data) {
    return(TRUE);
}

char* format_num (double in) { 
    static char *units[] = { "B", "KB", "MB", "GB", "TB" }; 
    char **unit, *tmp; 
    static char out[50]; 
 
    /* convert it to X Y, where X is less than 1024 and Y is the unit */ 
    for (unit = units; 
	 in > 1024 && unit < units + sizeof(units) / sizeof(*units) - 1; 
	 in /= 1024, ++unit); 

    snprintf (out, 40, "%.2f", in); 
 
    /* skip trailing zeros */ 
    for (tmp = out + strlen (out) - 1; 
	 tmp > out && *tmp == '0'; 
	 *tmp-- = 0); 

    if (*tmp == '.') 
	*tmp = 0; 
 
    strcat (out, " "); 
    strcat (out, *unit); 
    return out; 
} 

/* Should only be called from UI thread with normal gtk locking held */
void set_status_internal (GtkWidget *statusbar, const char* text) {
    if (statusbar) {
	guint context_id = 1;
	gtk_statusbar_pop (GTK_STATUSBAR (statusbar), context_id);
	gtk_statusbar_push (GTK_STATUSBAR (statusbar), context_id, text);
    }
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
