#!/usr/bin/python

import jppy
from optparse import OptionParser
import smtplib
from email.MIMEText import MIMEText
import datetime
from dateutil.tz import *

env = jppy.environment.Environment()
env.calendar.showPrivates = False

parser = OptionParser()
parser.add_option("-t", "--to",
                  dest="email", metavar="EMAIL",
                  help="Send mail to EMAIL")
parser.add_option("-f", "--from",
                  dest="frm", metavar="EMAIL",
                  help="Send mail from EMAIL")
parser.add_option("-p", "--period",
                  default="14",
                  dest="period", metavar="DAYS",
                  help="Notice period of DAYS")
parser.add_option("--smtp",
                  default="localhost",
                  dest="smtpserver", metavar="HOSTNAME",
                  help="Use HOSTNAME for SMTP server")

(options, args) = parser.parse_args()

if not options.email:
    parser.error("To email address required.")
if not options.frm:
    parser.error("From email address required.")

mail_body = []
current_day = None
startOfWeek = datetime.datetime.now(tzutc())-datetime.timedelta(
    days=datetime.datetime.now().weekday())
endOfPeriod = startOfWeek + datetime.timedelta(days=int(options.period))

# a version of env.calendar.eventsFromDate which also shows days with no events
def eventsOnDay(env, start, end):
    date = start
    while date != end:
        events = env.calendar.eventsOnDay(date)
        if len(events) > 0:
            for event in events:
                yield event
        else:
            yield (date, None)
        date = date + datetime.timedelta(days=1)
            

for date, event in eventsOnDay(env, startOfWeek, endOfPeriod):
    if date.date() != current_day:
        date_string = date.date().strftime("%A, %d %B %y")
        mail_body.append("\n- %s %s" % (date_string , "-" * (30 - len(date_string))))
        current_day = date.date()
    time_string = date.time().strftime("%I:%M%p").lower()
    if time_string == "12:00am":
        time_string = "       "
    if event is not None:
        mail_body.append((u"%s %s" % (time_string, event['description'])))
        

body = u"\n".join(mail_body)
msg=MIMEText(body.encode('iso-8859-15','replace'), _charset='iso-8859-15')
msg['Subject'] = "Two-weekly calendar for %s - %s" % (startOfWeek.date(),
                                                      endOfPeriod.date())
msg['From'] = options.frm
msg['To'] = options.email

server = smtplib.SMTP(options.smtpserver)
server.set_debuglevel(0)
server.sendmail(options.frm, [options.email], msg.as_string())
server.quit()
