from jppy.core import Component, ComponentManager, ExtensionPoint
from jppy.config import *
from jppy.api import IAddressBook, ITaskList, IMemoList, ICalendar, IInstallFile
import os
import logging

# a new Environment class will handle reading and keeping the config
class Environment(Component, ComponentManager):

    addressBook = ExtensionOption("jppy","addressBook",IAddressBook,
                                  "jppy.jpilot.legacy.addressBook")
    taskList    = ExtensionOption("jppy","taskList",ITaskList,
                                  "jppy.jpilot.legacy.taskList")
    memoList    = ExtensionOption("jppy","memoList",IMemoList,
                                  "jppy.jpilot.legacy.memoList")
    memo32List  = ExtensionOption("jppy","memo32List",IMemoList,
                                  "jppy.jpilot.legacy.memo32List")
    calendar    = ExtensionOption("jppy","calendar",ICalendar,
                                  "jppy.jpilot.legacy.calendar")
    installFile = ExtensionOption("jppy","installFile",IInstallFile,
                                  "jppy.jpilot.legacy.installFile")

    loglevel    = Option("jppy","loglevel","DEBUG")

    
    def __init__(self):
        ComponentManager.__init__(self)
        self.setup_config()
        self.setup_logging()

    def component_activated(self, component):
        """Initialize additional member variables for components.
        
        Every component activated through the `Environment` object gets three
        member variables: `env` (the environment object), `config` (the
        environment configuration) and `log` (a logger object)."""
        component.env = self
        component.config = self.config
        component.log = self.log

    def setup_logging(self):
        try:
            level = getattr(logging,self.loglevel)
        except:
            level = logging.DEBUG
        logging.basicConfig(level=level,
                            format='%(asctime)s %(levelname)-8s %(message)s',
                            datefmt='%a, %d %b %Y %H:%M:%S')
        self.log = logging.getLogger()

    def setup_config(self):
        """Load the configuration file."""
        filename = os.path.join(os.getenv('HOME'),".jppyrc")
        self.config = Configuration(filename)
        if not os.path.exists(filename):
            for section, default_options in self.config.defaults().items():
                for name, value in default_options.items():
                    self.config.set(section, name, value)
            self.config.save()
