/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class StandaloneJarProcessor {
    public static void run(File from, File to, JarProcessor proc) throws IOException {
        JarFile in = new JarFile(from);
        JarOutputStream out = new JarOutputStream(new FileOutputStream(to));
        byte[] buf = new byte[8192];
        EntryStruct struct = new EntryStruct();
        Enumeration<JarEntry> e = in.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            struct.in = in.getInputStream(entry);
            struct.name = entry.getName();
            struct.time = entry.getTime();
            struct.file = from;
            if (!proc.process(struct)) continue;
            entry = new JarEntry(struct.name);
            entry.setTime(struct.time);
            entry.setCompressedSize(-1L);
            out.putNextEntry(entry);
            StandaloneJarProcessor.pipe(struct.in, out, buf);
            struct.in.close();
        }
        out.close();
        out = null;
    }

    private static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }
}

