
/*
 * mixer.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MIXER_H
#define MIXER_H

#include "dialogs/typedefs.h"
#include "dialogs/dialogs.h"

#include "mpg123.h"

class MixerDialog : public MPG123Dialog
{
 public:
   /* Initialize flags */
   MixerDialog ();
   /* Set new settings */
   void SetSettings (int vol,int bass,int treble,int synth,int pcm,int ogain,int balance);
   /* Get current settings */
   void GetSettings (int &vol,int &bass,int &treble,int &synth,int &pcm,int &ogain,int &balance);
   /* Show mixer dialog */
   void ShowMixer ();
   /* Reload settings */
   void Reset ();
   /* Fade the volume down */
   void FadeDown ();
   /* Fade the volume up */
   void FadeUp ();
 private:
   /* Settings */
   int vol_volume;
   int vol_bass;
   int vol_treble;
   int vol_synth;
   int vol_pcm;
   int vol_ogain;
   int vol_balance;
   int saved_volume;
   /* Reload flag */
   bool reset;
   /* Functions */
   void drawbuttons (PANEL *panel,int x,int y);
   void drawbalance (PANEL *panel,int x,int y);
   int calcvolume (int volume);
};

#endif
