
/*
 * console.c -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYER_CONSOLE_C
#define PLAYER_CONSOLE_C

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "typedefs.h"
#include "console.h"

/*
 * Please note that this is a very simple "virtual console" and will probably
 * not work for any program that echos any strange escape characters. I wrote
 * it for juice, to support player output (i.e. it should support mpg123 (: )
 */

/* Estimated maximum length of a single line on the virtual screen */
#define INITIAL_LINE_LENGTH 255

/* Determines whether EOL will be interpreted as '\r\n' or just '\n' */
#define CARRIAGE_RETURN_MODE

static char *console_buffer;
static int console_length;

void console_create ()
{
   console_buffer = NULL;
   console_length = 0;
}

void console_write (const char *buffer,int buflen)
{
   char *buf,*line;
   int curpos,linepos,bufpos,linelen;
   bool newline;
   if (buflen <= 0) return;						 /* Let's not waste our time */
   console_buffer = (char *) realloc (console_buffer,(console_length + buflen) * sizeof (char));
   memcpy (console_buffer + console_length,buffer,buflen);
   console_length += buflen;
   buf = (char *) malloc (console_length * sizeof (char));
   linelen = INITIAL_LINE_LENGTH;
   line = (char *) malloc (linelen * sizeof (char));
   curpos = bufpos = 0;
   while (curpos < console_length)
	 {
		linepos = 0;
		newline = FALSE;
		while ((curpos < console_length) && (!newline))
		  {
#ifdef CARRIAGE_RETURN_MODE
			 if (console_buffer[curpos] == '\r')
			   {
				  if (curpos + 1 < console_length)	/* Don't touch if last character */
					{
					   if (console_buffer[curpos + 1] == '\n')	/* New line */
						 {
							if (linepos + 1 >= linelen )	/* Oops, our line is too short */
							  {
								 linelen += 10;		/* Increase if you feel this is not enough */
								 line = (char *) realloc (line,linelen * sizeof (char));
							  }
							line[linepos++] = console_buffer[curpos++];
							line[linepos++] = console_buffer[curpos];
							newline = TRUE;
						 }
					   else	linepos = 0;	/* Just carriage return => beginning of line */
					}
				  else
					{
					   if (linepos == linelen)	/* Oops, our line is too short */
						 {
							linelen += 10;	/* Increase if you feel this is not enough */
							line = (char *) realloc (line,linelen * sizeof (char));
						 }
					   line[linepos++] = console_buffer[curpos];
					}
			   }
			 else
			   {
				  if (linepos == linelen)	/* Oops, our line is too short */
					{
					   linelen += 10;	/* Increase if you feel this is not enough */
					   line = (char *) realloc (line,linelen * sizeof (char));
					}
				  line[linepos++] = console_buffer[curpos];
			   }
#else
			 if (console_buffer[curpos] != '\n')
			   {
				  if (console_buffer[curpos] != '\r')
					{
					   if (linepos == linelen)	/* Oops, our line is too short */
						 {
							linelen += 10;	/* Increase if you feel this is not enough */
							line = (char *) realloc (line,linelen * sizeof (char));
						 }
					   line[linepos++] = console_buffer[curpos];
					}
				  else linepos = 0;
			   }
			 else
			   {
				  if (linepos == linelen)	/* Oops, our line is too short */
					{
					   linelen += 10;	/* Increase if you feel this is not enough */
					   line = realloc (line,linelen * sizeof (char));
					}
				  line[linepos++] = console_buffer[curpos];
				  newline = TRUE;
			   }
#endif
			 curpos++;
		  }
		memcpy (buf + bufpos,line,linepos);
		bufpos += linepos;
	 }
   console_length = bufpos;
   console_buffer = (char *) realloc (console_buffer,console_length * sizeof (char));
   memcpy (console_buffer,buf,console_length);
   free (buf);
   free (line);
}

void console_restore (int fd)
{
   write (fd,console_buffer,console_length);
}

void console_destroy ()
{
   free (console_buffer);
}

#endif
