# $Id: Simple.pm,v 1.1.1.1 2005/06/28 04:25:15 kuro Exp $
package Juman::Simple;
require 5.000;
use Juman;
use strict;
use base qw/ Exporter /;
use vars qw/ @EXPORT /;
@EXPORT = qw/ juman /;

=head1 NAME

Juman::Simple - ǲϤԤ⥸塼

=head1 DESCRIPTION

C<Juman::Simple> ϡJuman ѤƷǲϤԤؿ C<juman> 
⥸塼Ǥ롥

Υ⥸塼ȤȡC<Juman> ⥸塼ñˡ¤줿
Ѥ뤳ȤǤ롥㤨СΥ⥸塼ϡǽ˺ 
C<Juman> ֥ȤѤΤǡץѹʤɤϤǤ
ʤ٤ǷǲϤԤɬפϡC<Juman> ⥸塼
ľܸƤӽФȡ

=head1 FUNCTION

=over 4

=item juman ($str)

ꤵ줿ʸоݤȤƷǲϤԤؿC<Juman::Result> 
֥Ȥ֤

  Example:

    use Juman::Simple;
    $result = &juman( "ʸǲϤƤ" );
    print $result->all();

ǲϤΥץѹϡC<use> λǻꤷƤ

  Example:

    use Juman::Simple -Option => "-B -e2";
    $result = &juman( "ʸǲϤƤ" );
    print $result->all();

ץˤϡC<Juman::new> μդ륪ץƱΤ
롥

=cut
my @OPTION;
my $JUMAN;

sub import {
    my $class = shift;
    @OPTION = @_;
    $class->export_to_level( 1 );
}

sub juman {
    my( $str ) = @_;
    $JUMAN ||= Juman->new( @OPTION );
    $JUMAN->analysis( $str );
}

1;

=back

=head1 SEE ALSO

=over 4

=item *

L<Juman>

=item *

L<Juman::Result>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
