import sys
import __builtin__

def print_doc(out, obj, meth):
    doc = (getattr(obj, meth)).__doc__
    if doc == None:
        doc = ""
    lines = doc.split("\n")
    outstring = '\\n" + \n        "'.join(lines)
    print >> out, ('    public final static String %s_%s_doc = '
        % (obj.__name__, meth))
    print >> outfile,  '        "%s";\n' % outstring

opt = lambda n: getattr(__builtin__, n, None)

def f(): pass
try:
    raise Exception
except:
    _, _, tb = sys.exc_info() 

class C:
    f = f

m = C.f

types_list = [
object,
type,
unicode,
dict,
list,
slice,
super,
staticmethod,
float,
opt('enumerate'),
#open,
opt('basestring'),
long,
tuple,
str,
property,
int,
xrange,
file,
complex,
opt('bool'),
classmethod,
#buffer,
# +
type(f),
type(m),
type(f.func_code),
type(sys._getframe()),
type(tb),
#type(slice),
]

outfile = open("BuiltinDocs.java", "w")
print >> outfile, '//generated by make_pydocs.py\n'
print >> outfile, 'package org.python.core;\n'
print >> outfile, 'public class BuiltinDocs {\n'


for obj in types_list: 
    print >> outfile, '    //Docs for %s' % obj
    for meth in dir(obj):
        print_doc(outfile, obj, meth)

print >> outfile, '}'


