// K-3D
// Copyright (c) 1995-2006, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "node_name_map.h"
#include "result.h"
#include "string_cast.h"

namespace k3d
{

///////////////////////////////////////////////////////////////////////////////////
// node_name_map::implementation

class node_name_map::implementation
{
public:
	typedef std::vector<inode*> nodes_t;
	nodes_t m_nodes;
};

///////////////////////////////////////////////////////////////////////////////////
// node_name_map
	
node_name_map::node_name_map() :
	m_implementation(new implementation())
{
}

node_name_map::~node_name_map()
{
	delete m_implementation;
}

void node_name_map::add_nodes(const inode_collection::nodes_t& Nodes)
{
	m_implementation->m_nodes.insert(m_implementation->m_nodes.end(), Nodes.begin(), Nodes.end());
}

const std::string node_name_map::name(inode& Node)
{
	implementation::nodes_t::iterator i =
		std::find(m_implementation->m_nodes.begin(), m_implementation->m_nodes.end(), &Node);

	if(i != m_implementation->m_nodes.end())
		return string_cast(std::distance(m_implementation->m_nodes.begin(), i));
		
	return std::string();
}

inode* node_name_map::node(const std::string& Name)
{
	return_val_if_fail(Name.size(), 0);
	
	const unsigned long i = k3d::from_string<unsigned long>(Name, 0UL);
	return_val_if_fail(i < m_implementation->m_nodes.size(), 0);

	return m_implementation->m_nodes[i];
}

} // namespace k3d

