########################################################
# K3D_WITH_FREETYPE2

AC_DEFUN([K3D_WITH_FREETYPE2], [
AC_SUBST(K3D_FREETYPE2_SUBDIR)
AC_SUBST(K3D_FREETYPE2_CFLAGS)
AC_SUBST(K3D_FREETYPE2_LIBS)
AC_ARG_WITH(freetype2, [  --with-freetype2        build freetype2-based text plug-in [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	AC_MSG_CHECKING([for freetype2])
	if pkg-config --exists freetype2 >/dev/null 2>/dev/null; then
		K3D_FREETYPE2_VERSION=`pkg-config --modversion freetype2`
		K3D_FREETYPE2_CFLAGS=`pkg-config --cflags freetype2`
		K3D_FREETYPE2_LIBS=`pkg-config --libs freetype2`
		K3D_FREETYPE2_SUBDIR=freetype2
		AC_MSG_RESULT([found version $K3D_FREETYPE2_VERSION])
	elif freetype-config --version >/dev/null 2>/dev/null; then
		K3D_FREETYPE2_VERSION=`freetype-config --version`
		K3D_FREETYPE2_CFLAGS=`freetype-config --cflags`
		K3D_FREETYPE2_LIBS=`freetype-config --libs`
		K3D_FREETYPE2_SUBDIR=freetype2
		AC_MSG_RESULT([found version $K3D_FREETYPE2_VERSION])
	else
		AC_MSG_RESULT([no found.])
	fi
fi
])

