/***************************************************************************
                          qregvalidator.cpp  -  description
                             -------------------
    begin                : Wed Aug 9 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <iostream.h>

#include <qregvalidator.h>
#include <qstringlist.h>

QRegValidator::QRegValidator(QString s, QWidget *parent, const char *name )
    : QValidator(parent,name)
{
  compiledPattern=new regex_t;
  valid=!regcomp(compiledPattern, s, REG_EXTENDED);
  if (!valid) cerr << "Ignoring invalid regular expression:" << s << '\n';

}

QRegValidator::~QRegValidator()
{
  delete compiledPattern;
}

QValidator::State QRegValidator::validate(QString & s, int &) const
{
  regmatch_t regs[10];
  QValidator::State state=QValidator::Invalid;
  const char * str=s;
  if (valid && str && regexec(compiledPattern, str, 10, regs, 0)==0)
    state=QValidator::Acceptable;
  return state;
}

int substitute2(QString & pattern, QString & src, QString & replacement, QString & dest, int & destEnd)
{
/*  cout << pattern << '\n'
       << src << '\n'
       << replacement << "\n\n";*/
  regex_t pattern_buffer;
  regmatch_t regs[10];
  /* try to compile pattern */
  int err;
  if (src.isNull() || (err=regcomp(&pattern_buffer, pattern, REG_EXTENDED)) )
  {
    char msg[100];
    regerror(err, &pattern_buffer, msg, 100);
    cerr << "Error in regular expression: " << pattern << '\n' << msg << '\n';
    /* if error occured, do not make substitution */
    dest=src;
    return 0;
  }
  /* match the pattern against the given string */
  if (regexec(&pattern_buffer, src, 10, regs, 0)!=0)
  {
    /* no match */
    dest=src;
    return 0;
  }
  /* copy the part left to the point where the matching starts */
  dest=src.left(regs[0].rm_so);
  int i=0;
  while (i<replacement.length()) {
    if (replacement[i]=='\\') {
      i++;
      if (replacement[i]>='0' && replacement[i]<='9') {
        int num=replacement[i].latin1()-'0';
        dest+=src.mid(regs[num].rm_so, regs[num].rm_eo - regs[num].rm_so);
      } else
        dest+=replacement[i];
    }
    else
      dest+=replacement[i];
    i++;
  }
  destEnd=dest.length();
  dest+=src.mid(regs[0].rm_eo, src.length() - regs[0].rm_eo);

  /* return the end of thecd last match */
  return dest.compare(src);
}

int substitute(QString & pattern, QString & src, QString & replacement, QString & dest, bool global)
{
  QString srcLeft, srcRight, destRight, result;
  int differ, index=0, de=0;

  if (global)
  {
    result=src;
    do {
      srcLeft=result.left(index);
      srcRight=result.right(result.length()-index);
      differ=substitute2(pattern, srcRight, replacement, destRight, de);
      result=srcLeft+destRight;
      index+=de;
    } while (differ);
    dest=result;
  }
  else
    substitute2(pattern, src, replacement, dest, de);
  return 0;
}

/* translate a string like sed's y */
int translate(QString & from, QString & to, QString & src, QString & dest)
{
  int i, pos;
  dest=QString();
  for (i=0; i<src.length(); i++)
  {
    pos=from.find(src[i]);
    if (pos>=0 && pos<to.length()) dest+=to[pos];
    else dest+=src[i];
  }
  return 1;
}

int match(QString & pattern, QString & src, QStringList & matches)
{
  matches=QStringList();
  regex_t pattern_buffer;
  regmatch_t regs[10];
  /* try to compile pattern */
  int err;
  if (src.isNull() || (err=regcomp(&pattern_buffer, pattern, REG_EXTENDED)) )
  {
    char msg[100];
    regerror(err, &pattern_buffer, msg, 100);
    cerr << "Error in regular expression: " << pattern << '\n' << msg << '\n';
    /* if error occured, do not make substitution */
    return 0;
  }
  /* match the pattern against the given string */
  if (regexec(&pattern_buffer, src, 10, regs, 0)!=0)
    /* no match */
    return 0;
  /* copy the part left to the point where the matching starts */

  int i;
  for (i=1; i<9; i++)
  {
    if (regs[i].rm_so>=0)
      matches+=src.mid(regs[i].rm_so, regs[i].rm_eo - regs[i].rm_so);
  }

  /* return the end of thecd last match */
  return matches.count();
}
