/***************************************************************************
                          kexecutor.cpp  -  description
                             -------------------
    begin                : Fri Aug 11 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kexecutor.h"

KExecutor::KExecutor()
{
}

KExecutor::~KExecutor()
{
}

void KExecutor::readStdout(KProcess *, char *buffer, int buflen)
{
  stdoutList.append(QString::fromLocal8Bit(buffer, buflen));
}


QString KExecutor::execute(QCString command)
{
  s << QString(command);
  connect(&s, SIGNAL(receivedStdout (KProcess *, char *, int)),
               SLOT(readStdout (KProcess *, char *, int)));
  s.start(KProcess::Block, KProcess::Stdout);
  QString result=stdoutList.join(QString());
//  QString result=stdoutList.join("\n");
  if (result[result.length()-1]==QChar('\n')) result.truncate(result.length()-1);
  return result;
}

QString KExecutor::execute(QStringList list)
{
  for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
    s << (*it);

  connect(&s, SIGNAL(receivedStdout (KProcess *, char *, int)),
               SLOT(readStdout (KProcess *, char *, int)));
  s.start(KProcess::Block, KProcess::Stdout);
  QString result=stdoutList.join(QString());
//  QString result=stdoutList.join("\n");
//  if (result[result.length()-1]==QChar('\n')) result.truncate(result.length()-1);
  return result;
}