/*
    This file is part of KitchenSync.

    Copyright (c) 2005 Simone Gotti <simone.gotti@email.it>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <addressbooksyncee.h>
#include <calendarsyncee.h>
#include <calendarmerger.h>
#include <addressbookmerger.h>

#include "device.h"

using KSync::AddressBookSyncee;
using KSync::CalendarSyncee;

using namespace IrMCSyncHelper;

Device::Device( enum Model model )
  : mABookMerger( 0l ), mCalendarMerger( 0l )
{
    m_model = model;
}

Device::~Device() {
}

int Device::model()const {
    return m_model;
}

void Device::setModel( int model ) {
    m_model = model;
    // The model can be changed, so we remove the already created mergers.
    if ( mCalendarMerger ) {
      delete mCalendarMerger;
      mCalendarMerger = 0;
    }
    if ( mABookMerger ) {
      delete mABookMerger;
      mABookMerger = 0;
    }
}

KSync::Merger* Device::merger( enum PIM pim )
{
  KSync::Merger* merger;

  switch( pim ) {
    case Calendar:
      switch ( m_model ) {
        case T68i:
          merger = T68iCalendarMerger();
          break;
        default:
          merger = 0;
      }
      break;
    case Addressbook:
      switch ( m_model ) {
        case T68i:
          merger = T68iAddressBookMerger();
          break;
        default:
          merger = 0;
      }
      break;
    default:
      merger = 0;
  }

  return merger;
}

KSync::Merger* Device::T68iCalendarMerger(){
  if ( mCalendarMerger )
    return mCalendarMerger;

  QBitArray cal( KSync::CalendarMerger::DtEnd+1 );
  cal[KSync::CalendarMerger::Organizer] = false;
  cal[KSync::CalendarMerger::ReadOnly ] = false;
  cal[KSync::CalendarMerger::DtStart  ] = true;
  cal[KSync::CalendarMerger::Duration ] = false;
  cal[KSync::CalendarMerger::Float    ] = false;
  cal[KSync::CalendarMerger::Attendee ] = false;
  cal[KSync::CalendarMerger::CreatedDate ] = false;
  cal[KSync::CalendarMerger::Revision ] = false;
  cal[KSync::CalendarMerger::Description ] = false;
  cal[KSync::CalendarMerger::Summary] = true;
  cal[KSync::CalendarMerger::Category ] = false;
  cal[KSync::CalendarMerger::Relations ] = false;
  cal[KSync::CalendarMerger::ExDates ] = false;
  cal[KSync::CalendarMerger::Attachments ] = false;
  cal[KSync::CalendarMerger::Secrecy ] = false;
  cal[KSync::CalendarMerger::Resources ] = false;
  cal[KSync::CalendarMerger::Priority ] = false;
  cal[KSync::CalendarMerger::Alarms ] = true; 
  cal[KSync::CalendarMerger::Recurrence ] = false; 
  cal[KSync::CalendarMerger::Location] = true;
  cal[KSync::CalendarMerger::DtEnd ] = true;

  // todo stuff
  QBitArray todo(KSync::CalendarMerger::DueDateTime+1);
  todo[KSync::CalendarMerger::Organizer] = false;
  todo[KSync::CalendarMerger::ReadOnly] = false;
  todo[KSync::CalendarMerger::DtStart] = true;
  todo[KSync::CalendarMerger::Duration] = false;
  todo[KSync::CalendarMerger::Float] = false;
  todo[KSync::CalendarMerger::Attendee] = false;
  todo[KSync::CalendarMerger::CreatedDate] = false;
  todo[KSync::CalendarMerger::Revision] = false;
  todo[KSync::CalendarMerger::Description] = false;
  todo[KSync::CalendarMerger::Summary] = true;
  todo[KSync::CalendarMerger::Category] = false;
  todo[KSync::CalendarMerger::Relations] = false;
  todo[KSync::CalendarMerger::ExDates] = false;
  todo[KSync::CalendarMerger::Attachments] = false;
  todo[KSync::CalendarMerger::Secrecy] = false;
  todo[KSync::CalendarMerger::Priority] = true;
  todo[KSync::CalendarMerger::Alarms] = true;
  todo[KSync::CalendarMerger::Recurrence] = false;
  todo[KSync::CalendarMerger::Location] = true;
  todo[KSync::CalendarMerger::StartDate] = true;
  todo[KSync::CalendarMerger::Completed] = true;
  todo[KSync::CalendarMerger::Percent] = false;
  todo[KSync::CalendarMerger::StartDateTime] = false;
  todo[KSync::CalendarMerger::DueDateTime] = false;

  mCalendarMerger = new KSync::CalendarMerger(todo, cal );

  return mCalendarMerger;
}

KSync::Merger* Device::T68iAddressBookMerger(){
  if ( mABookMerger )
    return mABookMerger;

  QBitArray ar(KSync::AddressBookMerger::Emails +1 );

  ar[KSync::AddressBookMerger::FamilyName] = true;
  ar[KSync::AddressBookMerger::GivenName] = true;
  ar[KSync::AddressBookMerger::AdditionalName] = false;
  ar[KSync::AddressBookMerger::Prefix ] = false;
  ar[KSync::AddressBookMerger::Suffix] = false;
  ar[KSync::AddressBookMerger::NickName] = false;
  ar[KSync::AddressBookMerger::Birthday] = false;
  ar[KSync::AddressBookMerger::HomeAddress ] = false;
  ar[KSync::AddressBookMerger::BusinessAddress]= false;
  ar[KSync::AddressBookMerger::TimeZone] = false;
  ar[KSync::AddressBookMerger::Geo ] = false;
  ar[KSync::AddressBookMerger::Title ] = false;
  ar[KSync::AddressBookMerger::Role ] = false;
  ar[KSync::AddressBookMerger::Organization ] = true;
  ar[KSync::AddressBookMerger::Note ] = false;
  ar[KSync::AddressBookMerger::Url ] = false;
  ar[KSync::AddressBookMerger::Secrecy ] = false;
  ar[KSync::AddressBookMerger::Picture ] = false;
  ar[KSync::AddressBookMerger::Sound ] = false;
  ar[KSync::AddressBookMerger::Agent ] = false;
  ar[KSync::AddressBookMerger::HomeNumbers] = true;
  ar[KSync::AddressBookMerger::OfficeNumbers] = true;
  ar[KSync::AddressBookMerger::Messenger ] = false;
  ar[KSync::AddressBookMerger::PreferredNumber ] = false;
  ar[KSync::AddressBookMerger::Voice ] = false;
  ar[KSync::AddressBookMerger::Fax ] = false;
  ar[KSync::AddressBookMerger::Cell ] = true;
  ar[KSync::AddressBookMerger::Video ] = false;
  ar[KSync::AddressBookMerger::Mailbox ] = false;
  ar[KSync::AddressBookMerger::Modem ] = false;
  ar[KSync::AddressBookMerger::CarPhone ] = false;
  ar[KSync::AddressBookMerger::ISDN ] = false;
  ar[KSync::AddressBookMerger::PCS ] = false;
  ar[KSync::AddressBookMerger::Pager ] = false;
  ar[KSync::AddressBookMerger::HomeFax] = false;
  ar[KSync::AddressBookMerger::WorkFax] = false;
  ar[KSync::AddressBookMerger::OtherTel] = false;
  ar[KSync::AddressBookMerger::Category] = false;
  ar[KSync::AddressBookMerger::Custom] = false;
  ar[KSync::AddressBookMerger::Keys] = false;
  ar[KSync::AddressBookMerger::Logo] = false;
  ar[KSync::AddressBookMerger::Email] = true;
  ar[KSync::AddressBookMerger::Emails] = false;

  mABookMerger = new KSync::AddressBookMerger( ar );

  return mABookMerger;
}
