//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "devicenamecache.h"
#include <libkbluetooth/adapter.h>
#include <libkbluetooth/hcisocket.h>

#include <kconfig.h>
#include <kdebug.h>
#include <kstandarddirs.h>
//#include <knotifyclient.h>
#include <klocale.h>

#include <sys/socket.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>


using namespace KBluetooth;

DeviceNameCache::DeviceNameCache(QObject* parent) :
    DCOPObject("DeviceNameCache"), QObject(parent)
{
    m_config = new KConfig("kbluetoothdrc");
    loadDeviceCache();

    //this->hciSocket = NULL;
    //slotHciConnect();
}

DeviceNameCache::~DeviceNameCache()
{
    storeDeviceCache();
    delete m_config;
}

/*void DeviceNameCache::slotHciConnect()
{
    if (hciSocket) delete hciSocket;
    this->hciSocket = new KBluetooth::HciSocket(this);
    if (!hciSocket->open())
    {
        delete hciSocket;
        hciSocket = NULL;
        kdDebug() << "Kbluetoothd: Error opening HCI socket"
        << endl;
    }
    else
    {
        connect(hciSocket, SIGNAL(event(unsigned char, QByteArray)),
            this, SLOT(slotHciEvent(unsigned char, QByteArray)));
        connect(hciSocket, SIGNAL(error(int, QString)),
            this, SLOT(slotHciConnectionClosed()));
        connect(hciSocket, SIGNAL(connectionClosed()),
            this, SLOT(slotHciConnectionClosed()));
    }
}*/


/*void DeviceNameCache::slotHciConnectionClosed()
{
}*/

void DeviceNameCache::loadDeviceCache()
{
    m_config->setGroup("DeviceCache");
    QStringList addrList = m_config->readListEntry("deviceList");
    for (uint n = 0; n < addrList.count(); ++n) {
        DeviceAddress devAddr = DeviceAddress(addrList[n]);
        PeerInfo info;
        info.name = m_config->readEntry(devAddr+"_name");
        info.devClass = m_config->readNumEntry(devAddr+"_class");
        //info.lastConnected = m_config->readDateTimeEntry(devAddr+"_lastConnected");
        //info.lastDiscovered = m_config->readDateTimeEntry(devAddr+"_lastDiscovered");
        //info.lastNameRequest = m_config->readDateTimeEntry(devAddr+"_lastNameRequest");
        addrInfoMap[devAddr] = info;
        nameAddrMap[info.name.lower()] = devAddr;
    }
}

void DeviceNameCache::storeDeviceCache()
{
    m_config->deleteGroup("DeviceCache", true);
    m_config->setGroup("DeviceCache");
    QStringList addrList;
    QMap<DeviceAddress, PeerInfo>::iterator it;
    for (it = addrInfoMap.begin(); it != addrInfoMap.end(); ++it) {
        QString devAddr = QString(it.key());
        addrList.append(devAddr);
        m_config->writeEntry(devAddr+"_name", it.data().name);
        m_config->writeEntry(devAddr+"_class", it.data().devClass);
        //m_config->writeEntry(devAddr+"_lastConnected", it.data().lastConnected);
        //m_config->writeEntry(devAddr+"_lastDiscovered", it.data().lastDiscovered);
        //m_config->writeEntry(devAddr+"_lastNameRequest", it.data().lastNameRequest);
    }
    m_config->writeEntry("deviceList", addrList);
}

QString DeviceNameCache::resolveCachedDeviceName(QString name)
{
    kdDebug() << QString("resolveCachedDeviceName: %1=%2")
        .arg(name).arg(QString(nameAddrMap[name.lower()])) << endl;
    return QString(nameAddrMap[name.lower()]);
}

int DeviceNameCache::getCachedDeviceClass(QString addrString)
{
    if (addrInfoMap.find(DeviceAddress(addrString)) != addrInfoMap.end()) {
        return addrInfoMap[DeviceAddress(addrString)].devClass;
    }
    else return 0;
}

QString DeviceNameCache::getCachedDeviceName(QString addrString)
{
    if (addrInfoMap.find(DeviceAddress(addrString)) != addrInfoMap.end()) {
        return addrInfoMap[DeviceAddress(addrString)].name;
    }
    else return addrString;
}


void DeviceNameCache::slotNameRequest(int error, KBluetooth::DeviceAddress addr, QString name)
{
    kdDebug() << "DeviceNameCache::slotNameRequest" << endl;
    if (error == 0) {
        addrInfoMap[addr].name = name;
        nameAddrMap[name.lower()] = addr;
    }
}

void DeviceNameCache::slotInquiryResult(KBluetooth::DeviceAddress addr, int deviceClass)
{
    kdDebug() << "DeviceNameCache::slotInquiryResult" << endl;
    addrInfoMap[addr].devClass = deviceClass;
}

#include "devicenamecache.moc"
