/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
/*
  Mattia's Post-It:
   - combo_status_old_value: to be removed, or done better
*/

void DevicesWindow::localdevices_selectionChanged( QListBoxItem* item )
{
    QApplication::setOverrideCursor(WaitCursor);
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    if (bluezConnector->setCurrentDevice(item->text().ascii()))
        setFormValues(bluezConnector->getCurrentDevice());

    cout << item->text().local8Bit() << endl;
    this->localdevices_current_device = this->localdevices->currentItem();
    cout << "LOCAL DEVICE NOW: " << this->localdevices_current_device << endl;
    QApplication::restoreOverrideCursor();
}

void DevicesWindow::pushbutton_update_clicked()
{
    BluezConnector::Update();
    this->windowContentUpdate();
    this->cleanWindowContent();
    localdevices_current_device = -1;
}

void DevicesWindow::pushbutton_reset_clicked()
{
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();

    cout << "dev == NULL? " << ((dev == NULL)? "yes" : "no") << endl;

    if (dev!=NULL)
    {
        cout << "is it a permission problem ?" << endl;
          if (bluezConnector->getCurrentDevice()->reset() == EACCES)
          {
             cout << "ok, it's permission problem ..." << endl;
             DevicesWindow::permissionAlert();
          }
    } else {
      QMessageBox::information(
        NULL,"Ooops !","Please select a device, first !","Ok!");
    }
    //  this->update();
}

void DevicesWindow::combo_status_activated( int idx )
{
    QApplication::setOverrideCursor(WaitCursor);
    cout << "DevicesWindow::combo_status_textChanged: " << idx << endl;
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    if (localdevices_current_device != -1) {
      if (bluezConnector->setCurrentDevice(
          this->localdevices->currentText().ascii()))
        if (idx == COMBO_ENABLED) {
            cout << "(idx == COMBO_ENABLED)" << endl;
            bluezConnector->getCurrentDevice()->devUp();
            combo_status_old_value = COMBO_ENABLED;
        }
        if (idx == COMBO_DISABLED) {
            cout << "(idx == COMBO_DISABLED)" << endl;
            bluezConnector->getCurrentDevice()->devDown();
            combo_status_old_value = COMBO_DISABLED;
        }
        if (idx == COMBO_UNKNOWN) {
            cout << "(idx == COMBO_UNKNOWN)" << endl;
            this->combo_status->setCurrentItem(combo_status_old_value);
        }
        this->setFormValues(bluezConnector->getCurrentDevice());
    }
    else {
        this->combo_status->setCurrentItem(COMBO_UNKNOWN);
    }
    QApplication::restoreOverrideCursor();
}

void DevicesWindow::pushbutton_show_details_clicked()
{
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();
    QString prop;
    QString caption;

    cout << "dev == NULL? " << ((dev == NULL)? "yes" : "no") << endl;

    if (dev!=NULL)
    {
        if (dev->getStatus())
        {
            QString features = (QString::fromAscii(dev->getFeatures()))
                               .replace('<',"&lt;").replace('>',"&gt;");
            prop.sprintf("<b>Features: </b>%s<br>"
                         "<b>Manufacturer: </b>%s<br>"
                         "<b>Revision: </b>%s",
                         features.ascii(),dev->getManufacturer(),dev->getRevision());
            caption = QString::fromAscii("Device Features");
        }
        else
        {
            prop = QString::fromAscii("This operation requires the device UP");
            caption = QString::fromAscii("Sorry !");
        }
    }
    else
    {
        prop = QString::fromAscii("Please select a device, first !");
        caption = QString::fromAscii("Ooops !");
    }
    QMessageBox::information(NULL,caption,prop,"Ok!");
}

void DevicesWindow::combo_inquiry_or_page_scan_activated( int idx ) {
  BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
  BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();

  cout << COMBO_UNKNOWN << " : " << dev->getIScan() << endl;
  if (idx == COMBO_UNKNOWN) {
    this->combo_inquiry_scan_enabled->setCurrentItem(
      flagsToCombo(dev->getIScan()));
    this->combo_page_scan_enabled->setCurrentItem(
      flagsToCombo(dev->getPScan()));
  } else {
    dev->setScanMode(
      (this->combo_inquiry_scan_enabled->currentItem() == COMBO_ENABLED),
      (this->combo_page_scan_enabled->currentItem() == COMBO_ENABLED));
  }
}

void DevicesWindow::combo_inquiry_scan_activated( int idx ) {
  combo_inquiry_or_page_scan_activated(idx);
}

void DevicesWindow::combo_page_scan_activated( int idx ) {
  combo_inquiry_or_page_scan_activated(idx);
}

void DevicesWindow::lineedit_name_lost_focus() {
  cout << "lost focus !" << endl;
  devNameFromLineEdit();
}

void DevicesWindow::lineedit_name_return_pressed() {
  cout << "it's Qt::Key_Return" << endl;
  devNameFromLineEdit();
}

void DevicesWindow::devNameFromLineEdit() {
  if (getUserIsRoot()) {
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();
    dev->changeDevName(lineedit_name->text().ascii());
  }
}

void DevicesWindow::combo_authentication_activated( int idx ) {
  BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
  BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();
  if (idx == COMBO_UNKNOWN) {
    combo_authentication_enabled->setCurrentItem(flagsToCombo(dev->getAuth()));
  } else {
    dev->changeAuthentication(
      this->combo_authentication_enabled->currentItem() == COMBO_ENABLED);
  }

  combo_authentication_enabled->setCurrentItem(flagsToCombo(dev->getAuth()));
  combo_encryption_enabled->setCurrentItem(flagsToCombo(dev->getEncrypt()));
}

void DevicesWindow::combo_encryption_activated( int idx ) {
  BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
  BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();
  if (idx == COMBO_UNKNOWN) {
    combo_encryption_enabled->setCurrentItem(flagsToCombo(dev->getEncrypt()));
  } else {
    dev->changeEncryption(
      this->combo_encryption_enabled->currentItem() == COMBO_ENABLED);
  }

  combo_authentication_enabled->setCurrentItem(flagsToCombo(dev->getAuth()));
  combo_encryption_enabled->setCurrentItem(flagsToCombo(dev->getEncrypt()));
}

void DevicesWindow::pushbutton_show_device_class_window() {
  BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
  BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();
  if (dev->getStatus()) {
    DeviceClassDialog* dcd = new DeviceClassDialog();
    dcd->lineedit_hex_update();
    int res = dcd->exec();
    cout << "DeviceClassDialog->exec() result is: " << res << endl;
    if (res && getUserIsRoot()) {
      dev->changeClass(dcd->getServiceValue(),dcd->getMajorValue(),dcd->getMinorValue());
    }
    delete dcd;
  }
  else {
    QMessageBox::information(NULL,QString::fromAscii("Sorry !"),QString::fromAscii("This operation requires the device UP"),"Ok!");
  }
}
