#!/bin/sh
# This file is part of the kbluelock application.
#
# Makes kbluelock as the default screenlock for
# the system.

KLOCK=`which kdesktop_lock`
BASE_PATH=`dirname $KLOCK`
KBLUELOCK=$BASE_PATH/kbluelock
NEW_KLOCK=$BASE_PATH/kdesktop_lock_nobt

if [ -f $NEW_KLOCK ]; then
  exit 1
fi

[ -x $KLOCK ] || exit 2
[ -x $KBLUELOCK ] || exit 3

chown --reference=$KLOCK $KBLUELOCK
chmod --reference=$KLOCK $KBLUELOCK

mv $KLOCK $NEW_KLOCK
[ -x $NEW_LOCK ] || exit 4

mv $KBLUELOCK $KLOCK
[ -x $KLOCK ] || exit 5

exit 0
