/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kdebug.h>

#include <iostream>
using namespace std;

void DeviceClassDialog::listbox_major_selected() {
  QString* str_minors;
  int major_val = 0;
  major_val =
    (listbox_major->currentItem() == 7)?63:listbox_major->currentItem();
  str_minors = new QString(DeviceClass::get_minors(major_val));
  QStringList str_list_minors =
    QStringList::split( ',' , *str_minors );

  listbox_minor->clear();
  listbox_minor->insertStringList(str_list_minors);

  kdDebug() << "minors are: " << str_minors->ascii()  << endl;

  setMajorValue(major_val);
  lineedit_hex_update();
}

void DeviceClassDialog::listbox_services_selected() {
  int selections[8];
  int i=0;
  int count=0;
  for (i=0;i<8;i++) {
    if (listbox_services->isSelected(i)) {
      selections[count++]=i;
    }
  }
  setServiceValue(DeviceClass::getServicesMask(selections,count));
  lineedit_hex_update();
}

void DeviceClassDialog::lineedit_hex_update() {
  QString* tmp = new QString();
  tmp->sprintf("0x%02x%02x%02x",service_val,major_val,minor_val);
  cout << "sv: " << service_val << " Mv: " << major_val << " mv: " << minor_val << endl;
  lineedit_hex->setText(*tmp);
}

void DeviceClassDialog::listbox_minor_selected( QListBoxItem* /*item*/) {
  setMinorValue(DeviceClass::get_minor_value(major_val,listbox_minor->currentItem()));
  lineedit_hex_update();
}
